<?php
/*
Plugin Name: LambertGroup - HTML5 Video Player with Multiple Skins
Plugin URI: http://www.lambertgroup.ro/wordpress_plugins/LambertGroup_HTML5_Video_Player_with_Multiple_Skins.html
Description: This plugin will allow you to insert an HTML5 Video Player with Multiple Skins.
Version: 4.3.1
Author: Lambert Group
Author URI: http://www.lambertgroup.ro
*/

ini_set('display_errors', 0);
$lbg_vp1_html5_path = trailingslashit(dirname(__FILE__));  //empty

//all the messages
$lbg_vp1_html5_messages = array(
		'version' => '<div class="error">LBG - HTML5 Video Player with Multiple Skins plugin requires WordPress 3.0 or newer. <a href="http://codex.wordpress.org/Upgrading_WordPress">Please update!</a></div>',
		'data_saved' => 'Data Saved!',
		'empty_name' => 'Name - required',
		'empty_movie' => 'Movie Path - required',
		'invalid_request' => 'Invalid Request!',
		'generate_for_this_player' => 'You can start customizing this player.',
	);

	
global $wp_version;

if ( !version_compare($wp_version,"3.0",">=")) {
	die ($lbg_vp1_html5_messages['version']);
}




function lbg_vp1_html5_activate() {
	//db creation, create admin options etc.
	global $wpdb;
	
	$lbg_collate = ' COLLATE utf8_general_ci';
	
	$sql0 = "CREATE TABLE `" . $wpdb->prefix . "lbg_vp1_html5_players` (
			`id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
			`name` VARCHAR( 255 ) NOT NULL ,
			PRIMARY KEY ( `id` )
			) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
	
	$sql1 = "CREATE TABLE `" . $wpdb->prefix . "lbg_vp1_html5_videosettings` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `playerWidth` smallint(5) unsigned NOT NULL DEFAULT '704',
  `playerHeight` smallint(5) unsigned NOT NULL DEFAULT '396',
  `skin` varchar(255) NOT NULL DEFAULT 'universalBlack',
  `seekBarAdjust` int(10) unsigned NOT NULL DEFAULT '220',
  `autoHideControllers` varchar(10) NOT NULL DEFAULT 'false',
  `showInfo` varchar(10) NOT NULL DEFAULT 'true',
  `loop` varchar(8) NOT NULL DEFAULT 'loop',
  `autoPlay` varchar(100) NOT NULL DEFAULT 'autoplay',
  `initialVolume` float unsigned NOT NULL DEFAULT '1',
  `preload` varchar(100) NOT NULL DEFAULT 'auto',
  `preview` text,
  `mp4` text NOT NULL,
  `ogv` text NOT NULL,
  `webm` text NOT NULL,
  `movieTitle` text,
  `movieDesc` text,
  `responsive` varchar(8) NOT NULL DEFAULT 'false',
  `responsiveRelativeToBrowser` varchar(8) NOT NULL DEFAULT 'false',
  `width100Proc` varchar(8) NOT NULL DEFAULT 'false',
  `height100Proc` varchar(8) NOT NULL DEFAULT 'false',
  `linkToGo` varchar(255) NOT NULL DEFAULT '',
  `target` varchar(8) NOT NULL DEFAULT '_blank',
  PRIMARY KEY (`id`)
	) ENGINE=MyISAM  DEFAULT CHARSET=utf8;";
	

	require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
	dbDelta($sql0.$lbg_collate);
	dbDelta($sql1.$lbg_collate);

	
	
	//initialize the players table with the first player type
	$rows_count = $wpdb->get_var("SELECT COUNT(*) FROM ". $wpdb->prefix ."lbg_vp1_html5_players;");
	if (!$rows_count) {
		$wpdb->insert( 
			$wpdb->prefix . "lbg_vp1_html5_players", 
			array( 
				'name' => 'Universal Black'
			), 
			array(
				'%s'			
			) 
		);	
	}	
	
	// initialize the settings
	$rows_count = $wpdb->get_var("SELECT COUNT(*) FROM ". $wpdb->prefix ."lbg_vp1_html5_videosettings;");
	if (!$rows_count) {
		lbg_vp1_html5_insert_settings_record(1);
	}	
	
}


function lbg_vp1_html5_uninstall() {
	global $wpdb;
	mysql_query("DROP TABLE `" . $wpdb->prefix . "lbg_vp1_html5_videosettings`" );
	mysql_query("DROP TABLE `" . $wpdb->prefix . "lbg_vp1_html5_players`" );
}

function lbg_vp1_html5_insert_settings_record($player_id) {
	global $wpdb;
	//$wpdb->show_errors();
	$wpdb->insert( 
			$wpdb->prefix . "lbg_vp1_html5_videosettings", 
			array( 
				'playerWidth' => 704, 
				'playerHeight' => 396,
				'skin' => 'universalBlack',
				'autoHideControllers' => 'false',
				'seekBarAdjust' => 220,
				'showInfo' => 'true',
				'loop' => '',
				'autoPlay' => '',
				'initialVolume' => 1,
			    'preload' => 'auto',
				'preview' => 'http://lambertgroupproductions.com/canyon/vp1_html5/videos/prevUB.jpg',
				'mp4' => 'http://lambertgroupproductions.com/canyon/vp2_html5/rightSidePlaylist/videos/big_buck_bunny_trailer.mp4',
                'ogv' => 'http://lambertgroupproductions.com/canyon/vp2_html5/rightSidePlaylist/videos/big_buck_bunny_trailer.ogv',
                'webm' => 'http://lambertgroupproductions.com/canyon/vp2_html5/rightSidePlaylist/videos/big_buck_bunny_trailer.webm',
				'movieTitle' => 'Your Movie Title',
				'movieDesc' => 'Your movie description. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec non ante vitae felis vestibulum lacinia ut sed felis. Aliquam mi libero, pretium consectetur pharetra eu, auctor non diam. Pellentesque adipiscing, justo in placerat sagittis, quam enim aliquet odio, nec laoreet leo neque et felis. Aliquam leo nulla, posuere eget dapibus quis, mattis non urna. Vestibulum blandit velit id tortor hendrerit a rhoncus tellus porta. Donec hendrerit ullamcorper sodales.'
			), 
			array( 
				'%d', 
				'%d',
				'%s',
				'%s',
				'%d',
				'%s',
				'%s',
				'%s',
				'%d',
				'%s',
				'%s', 
				'%s',			
				'%s', 
				'%s',
				'%s',
				'%s'
			) 
		);		
}


function lbg_vp1_html5_video_init_sessions() {
	global $wpdb;
	if (is_admin()) { 
		if (!session_id()) {
			session_start();
			
			//initialize the session
			if (!isset($_SESSION['xid'])) {
				$safe_sql="SELECT * FROM (".$wpdb->prefix ."lbg_vp1_html5_players) LIMIT 0, 1";
				$row = $wpdb->get_row($safe_sql,ARRAY_A);
				//$row=lbg_vp1_html5_unstrip_array($row);	
				$_SESSION['xid'] = $row['id'];
				$_SESSION['xname'] = $row['name'];
			}		
		}
	}
}


function lbg_vp1_html5_video_load_styles() {
	if(strpos($_SERVER['PHP_SELF'], 'wp-admin') !== false) { //loads css in admin
		$page = (isset($_GET['page'])) ? $_GET['page'] : '';
		if(preg_match('/LBG_VP1_HTML5/i', $page)) {
			
			//wp_enqueue_style('vp1_html5_player_jquery-custom_css', plugins_url('css/custom-theme/jquery-ui-1.8.10.custom.css', __FILE__));
			wp_enqueue_style('lbg-jquery-ui-custom_css', 'http://ajax.googleapis.com/ajax/libs/jqueryui/1.10.3/themes/pepper-grinder/jquery-ui.min.css');			
			wp_enqueue_style('vp1_html5_player_css', plugins_url('css/styles.css', __FILE__));
			//wp_enqueue_style('vp1_html5_player_colorpicker_css', plugins_url('css/colorpicker/colorpicker.css', __FILE__));
			
			wp_enqueue_style('thickbox');
		
		}
	} else if (!is_admin()) { //loads css in front-end
		wp_enqueue_style('vp1_html5_player_site_css', plugins_url('lbg_vp1_html5/css/vp1_html5.css', __FILE__));
	}
}

function lbg_vp1_html5_video_load_scripts() {
	$page = (isset($_GET['page'])) ? $_GET['page'] : '';
	if(preg_match('/LBG_VP1_HTML5/i', $page)) {
		//loads scripts in admin
		//if (is_admin()) {
			/*wp_deregister_script('jquery-ui-core');
			wp_deregister_script('jquery-ui-widget');
			wp_deregister_script('jquery-ui-mouse');
			wp_deregister_script('jquery-ui-accordion');
			wp_deregister_script('jquery-ui-autocomplete');
			wp_deregister_script('jquery-ui-slider');
			wp_deregister_script('jquery-ui-tabs');
			wp_deregister_script('jquery-ui-sortable');
			wp_deregister_script('jquery-ui-draggable');
			wp_deregister_script('jquery-ui-droppable');
			wp_deregister_script('jquery-ui-selectable');
			wp_deregister_script('jquery-ui-position');
			wp_deregister_script('jquery-ui-datepicker');
			wp_deregister_script('jquery-ui-resizable');
			wp_deregister_script('jquery-ui-dialog');
			wp_deregister_script('jquery-ui-button');*/	
						
			wp_enqueue_script('jquery');
			/*wp_register_script('lbg-admin-jquery', plugins_url('js/jquery-1.5.1.js', __FILE__));
			wp_enqueue_script('lbg-admin-jquery');*/
			
			//wp_register_script('lbg-admin-jquery-ui-min', plugins_url('js/jquery-ui-1.8.10.custom.min.js', __FILE__));
			//wp_register_script('lbg-admin-jquery-ui-min', 'http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.23/jquery-ui.min.js');
			/*wp_register_script('lbg-admin-jquery-ui-min', 'http://ajax.googleapis.com/ajax/libs/jqueryui/1.9.2/jquery-ui.min.js');
			wp_enqueue_script('lbg-admin-jquery-ui-min');*/
			wp_enqueue_script('jquery-ui-core');
			wp_enqueue_script('jquery-ui-widget');
			wp_enqueue_script('jquery-ui-mouse');
			wp_enqueue_script('jquery-ui-accordion');
			wp_enqueue_script('jquery-ui-autocomplete');
			wp_enqueue_script('jquery-ui-slider');
			wp_enqueue_script('jquery-ui-tabs');
			wp_enqueue_script('jquery-ui-sortable');
			wp_enqueue_script('jquery-ui-draggable');
			wp_enqueue_script('jquery-ui-droppable');
			wp_enqueue_script('jquery-ui-selectable');
			wp_enqueue_script('jquery-ui-position');
			wp_enqueue_script('jquery-ui-datepicker');
			wp_enqueue_script('jquery-ui-resizable');
			wp_enqueue_script('jquery-ui-dialog');
			wp_enqueue_script('jquery-ui-button');/***************************/
			
			wp_enqueue_script('jquery-form');
			wp_enqueue_script('jquery-color');
			wp_enqueue_script('jquery-masonry');
			wp_enqueue_script('jquery-ui-progressbar');
			wp_enqueue_script('jquery-ui-tooltip');
			
			wp_enqueue_script('jquery-effects-core');
			wp_enqueue_script('jquery-effects-blind');
			wp_enqueue_script('jquery-effects-bounce');
			wp_enqueue_script('jquery-effects-clip');
			wp_enqueue_script('jquery-effects-drop');
			wp_enqueue_script('jquery-effects-explode');
			wp_enqueue_script('jquery-effects-fade');
			wp_enqueue_script('jquery-effects-fold');
			wp_enqueue_script('jquery-effects-highlight');
			wp_enqueue_script('jquery-effects-pulsate');
			wp_enqueue_script('jquery-effects-scale');
			wp_enqueue_script('jquery-effects-shake');
			wp_enqueue_script('jquery-effects-slide');			
			wp_enqueue_script('jquery-effects-transfer');				
			
			wp_register_script('lbg-admin-colorpicker', plugins_url('js/colorpicker/colorpicker.js', __FILE__));
			wp_enqueue_script('lbg-admin-colorpicker');	

			wp_register_script('lbg-admin-toggle', plugins_url('js/myToggle.js', __FILE__));
			wp_enqueue_script('lbg-admin-toggle');
			
			wp_enqueue_script('media-upload');
			wp_enqueue_script('thickbox');			
			
		
			
		//}
		
		//wp_enqueue_script('jquery');
		//wp_enqueue_script('jquery-ui-core');
		//wp_enqueue_script('jquery-ui-sortable');
		//wp_enqueue_script('thickbox');
		//wp_enqueue_script('media-upload');
		//wp_enqueue_script('farbtastic');
	} else if (!is_admin()) { //loads scripts in front-end
			/*wp_deregister_script('jquery-ui-core');
			wp_deregister_script('jquery-ui-widget');
			wp_deregister_script('jquery-ui-mouse');
			wp_deregister_script('jquery-ui-accordion');
			wp_deregister_script('jquery-ui-autocomplete');
			wp_deregister_script('jquery-ui-slider');
			wp_deregister_script('jquery-ui-tabs');
			wp_deregister_script('jquery-ui-sortable');
			wp_deregister_script('jquery-ui-draggable');
			wp_deregister_script('jquery-ui-droppable');
			wp_deregister_script('jquery-ui-selectable');
			wp_deregister_script('jquery-ui-position');
			wp_deregister_script('jquery-ui-datepicker');
			wp_deregister_script('jquery-ui-resizable');
			wp_deregister_script('jquery-ui-dialog');
			wp_deregister_script('jquery-ui-button');*/	
				
		wp_enqueue_script('jquery');
		/*wp_deregister_script( 'jquery' );
		//wp_register_script( 'jquery', 'http://ajax.googleapis.com/ajax/libs/jquery/1.4.2/jquery.min.js');
		//wp_register_script( 'jquery', plugins_url('lbg_vp1_html5/js/jquery-1.4.2.min.js', __FILE__));
		wp_register_script( 'jquery', plugins_url('lbg_vp1_html5/js/jquery-1.7.1.min.js', __FILE__));
		wp_enqueue_script( 'jquery' );*/	
	
		//wp_enqueue_script('jquery-ui-core');
		
		//wp_register_script('lbg-jquery-ui-min', 'http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.23/jquery-ui.min.js');
		/*wp_register_script('lbg-jquery-ui-min', 'http://ajax.googleapis.com/ajax/libs/jqueryui/1.9.2/jquery-ui.min.js');
		wp_enqueue_script('lbg-jquery-ui-min');*/
			wp_enqueue_script('jquery-ui-core');
			wp_enqueue_script('jquery-ui-widget');
			wp_enqueue_script('jquery-ui-mouse');
			wp_enqueue_script('jquery-ui-accordion');
			wp_enqueue_script('jquery-ui-autocomplete');
			wp_enqueue_script('jquery-ui-slider');
			wp_enqueue_script('jquery-ui-tabs');
			wp_enqueue_script('jquery-ui-sortable');
			wp_enqueue_script('jquery-ui-draggable');
			wp_enqueue_script('jquery-ui-droppable');
			wp_enqueue_script('jquery-ui-selectable');
			wp_enqueue_script('jquery-ui-position');
			wp_enqueue_script('jquery-ui-datepicker');
			wp_enqueue_script('jquery-ui-resizable');
			wp_enqueue_script('jquery-ui-dialog');
			wp_enqueue_script('jquery-ui-button');/***************************/
			
			wp_enqueue_script('jquery-form');
			wp_enqueue_script('jquery-color');
			wp_enqueue_script('jquery-masonry');
			wp_enqueue_script('jquery-ui-progressbar');
			wp_enqueue_script('jquery-ui-tooltip');
			
			wp_enqueue_script('jquery-effects-core');
			wp_enqueue_script('jquery-effects-blind');
			wp_enqueue_script('jquery-effects-bounce');
			wp_enqueue_script('jquery-effects-clip');
			wp_enqueue_script('jquery-effects-drop');
			wp_enqueue_script('jquery-effects-explode');
			wp_enqueue_script('jquery-effects-fade');
			wp_enqueue_script('jquery-effects-fold');
			wp_enqueue_script('jquery-effects-highlight');
			wp_enqueue_script('jquery-effects-pulsate');
			wp_enqueue_script('jquery-effects-scale');
			wp_enqueue_script('jquery-effects-shake');
			wp_enqueue_script('jquery-effects-slide');			
			wp_enqueue_script('jquery-effects-transfer');			
		
		wp_register_script('lbg-vp1_html5', plugins_url('lbg_vp1_html5/js/vp1_html5.js', __FILE__));
		wp_enqueue_script('lbg-vp1_html5');	
		
		wp_register_script('lbg-screenfull', plugins_url('lbg_vp1_html5/js/screenfull.min.js', __FILE__));
		wp_enqueue_script('lbg-screenfull');
	}

}



// adds the menu pages
function lbg_vp1_html5_plugin_menu() {
	add_menu_page('LBG VP1 HTML5 Admin Interface', 'LBG VP1 HTML5', 'edit_posts', 'LBG_VP1_HTML5', 'lbg_vp1_html5_video_overview_page',
	plugins_url('images/lbg_video1_icon.png', __FILE__));
	add_submenu_page( 'LBG_VP1_HTML5', 'LBG VP1 HTML5 Overview', 'Overview', 'edit_posts', 'LBG_VP1_HTML5', 'lbg_vp1_html5_video_overview_page');
	add_submenu_page( 'LBG_VP1_HTML5', 'LBG VP1 HTML5 Manage Players', 'Manage Players', 'edit_posts', 'LBG_VP1_HTML5_Manage_Players', 'lbg_vp1_html5_video_player_manage_players_page');
	add_submenu_page( 'LBG_VP1_HTML5', 'LBG VP1 HTML5 Manage Players Add New', 'Add New', 'edit_posts', 'LBG_VP1_HTML5_Add_New', 'lbg_vp1_html5_video_player_manage_players_add_new_page');
	add_submenu_page( 'LBG VP1 HTML5 Manage Players', 'LBG VP1 HTML5 Player Settings', 'Player Settings', 'edit_posts', 'LBG_VP1_HTML5_Settings', 'lbg_vp1_html5_video_player_settings_page');
	add_submenu_page( 'LBG_VP1_HTML5', 'LBG VP1 HTML5 Help', 'Help', 'edit_posts', 'LBG_VP1_HTML5_Help', 'lbg_vp1_html5_video_player_help_page');
}


//HTML content for overview page
function lbg_vp1_html5_video_overview_page()
{
	include_once($lbg_vp1_html5_path . 'tpl/overview.php');
}

//HTML content for Manage Players
function lbg_vp1_html5_video_player_manage_players_page()
{
	global $wpdb;
	global $lbg_vp1_html5_messages;
	
	//$wpdb->show_errors();
	
	//delete player
	if (isset($_GET['id'])) {
		//delete from wp_lbg_vp1_html5_players
		$wpdb->query($wpdb->prepare("DELETE FROM ".$wpdb->prefix."lbg_vp1_html5_players WHERE id = %d",$_GET['id']));
		
		//delete from wp_lbg_vp1_html5_videosettings
		$wpdb->query($wpdb->prepare("DELETE FROM ".$wpdb->prefix."lbg_vp1_html5_videosettings WHERE id = %d",$_GET['id']));

		//initialize the session
		$safe_sql="SELECT * FROM (".$wpdb->prefix ."lbg_vp1_html5_players) ORDER BY id";
		$row = $wpdb->get_row($safe_sql,ARRAY_A);
		//$row=lbg_vp1_html5_unstrip_array($row);
		if ($row['id']) {
			$_SESSION['xid']=$row['id'];
			$_SESSION['xname']=$row['name'];
		}		
	}
	
	if ($_GET['duplicate_id']!='') {	
			//players
			$safe_sql=$wpdb->prepare( "INSERT INTO ".$wpdb->prefix ."lbg_vp1_html5_players ( `name` ) SELECT `name` FROM (".$wpdb->prefix ."lbg_vp1_html5_players) WHERE id = %d",$_GET['duplicate_id'] );
			$wpdb->query($safe_sql);			
			//$playerid=$wpdb->insert_id;
			
			//settings
			$safe_sql=$wpdb->prepare( "INSERT INTO ".$wpdb->prefix ."lbg_vp1_html5_videosettings (`movieTitle`, `movieDesc`, `preview`, `mp4`, `webm`, `ogv`, `playerWidth`, `playerHeight`, `width100Proc`, `height100Proc`, `responsive`, `responsiveRelativeToBrowser`, `skin`, `seekBarAdjust`, `showInfo`, `preload`, `loop`, `autoPlay`, `linkToGo`, `target`, `initialVolume`, `autoHideControllers` ) SELECT `movieTitle`, `movieDesc`, `preview`, `mp4`, `webm`, `ogv`, `playerWidth`, `playerHeight`, `width100Proc`, `height100Proc`, `responsive`, `responsiveRelativeToBrowser`, `skin`, `seekBarAdjust`, `showInfo`, `preload`, `loop`, `autoPlay`, `linkToGo`, `target`, `initialVolume`, `autoHideControllers` FROM (".$wpdb->prefix ."lbg_vp1_html5_videosettings) WHERE id = %d",$_GET['duplicate_id'] );
			$wpdb->query($safe_sql);
			//echo $wpdb->last_query;


	}	
	
	
	$safe_sql="SELECT * FROM (".$wpdb->prefix ."lbg_vp1_html5_players) ORDER BY id";
	$result = $wpdb->get_results($safe_sql,ARRAY_A);	
	include_once($lbg_vp1_html5_path . 'tpl/players.php');

}


//HTML content for Manage Players - Add New
function lbg_vp1_html5_video_player_manage_players_add_new_page()
{
	global $wpdb;
	global $lbg_vp1_html5_messages;
	
	if($_POST['Submit'] == 'Add New') {
		$errors_arr=array();
		if (empty($_POST['name']))
			$errors_arr[]=$lbg_vp1_html5_messages['empty_name'];

		if (count($errors_arr)) { 
				include_once($lbg_vp1_html5_path . 'tpl/add_player.php'); ?>
				<div id="error" class="error"><p><?php echo implode("<br>", $errors_arr);?></p></div>
		  	<?php } else { // no errors
					$wpdb->insert( 
						$wpdb->prefix . "lbg_vp1_html5_players", 
						array( 
							'name' => $_POST['name']
						), 
						array( 
							'%s'			
						) 
					);	
					//insert default player settings for this new player
					lbg_vp1_html5_insert_settings_record($wpdb->insert_id);
					?>
						<div class="wrap">
							<div id="lbg_logo">
								<h2>Manage Players - Add New Player</h2>
				 			</div>
							<div id="message" class="updated"><p><?php echo $lbg_vp1_html5_messages['data_saved'];?></p><p><?php echo $lbg_vp1_html5_messages['generate_for_this_player'];?></p></div>
							<div>
								<p>&raquo; <a href="?page=LBG_VP1_HTML5_Add_New">Add New (player)</a></p>
								<p>&raquo; <a href="?page=LBG_VP1_HTML5_Manage_Players">Back to Manage Players</a></p>
							</div>
						</div>	
		  	<?php }			
	} else {
		include_once($lbg_vp1_html5_path . 'tpl/add_player.php');
	}

}


//HTML content for playersettings
function lbg_vp1_html5_video_player_settings_page()
{
	global $wpdb;
	global $lbg_vp1_html5_messages;
	
	if (isset($_GET['id']) && isset($_GET['name'])) {
		$_SESSION['xid']=$_GET['id'];
		$_SESSION['xname']=$_GET['name'];
	}

	//$wpdb->show_errors();
	/*if (check_admin_referer('lbg_vp1_html5_settings_update')) {
		echo "update";		
	}*/

	
	if($_POST['Submit'] == 'Update Player Settings') {
		$except_arr=array('Submit','name','page_scroll_to_id_instances');
		$err_upload='';
		if ($err_upload=='') {
			$wpdb->update( 
				$wpdb->prefix .'lbg_vp1_html5_players', 
				array( 
				'name' => $_POST['name']
				), 
				array( 'id' => $_SESSION['xid'] )
			);	
			$_SESSION['xname']=stripslashes($_POST['name']);
						
			
			foreach ($_POST as $key=>$val){
				if (in_array($key,$except_arr)) {
					unset($_POST[$key]);
				}
			}
		
			$wpdb->update( 
				$wpdb->prefix .'lbg_vp1_html5_videosettings', 
				$_POST, 
				array( 'id' => $_SESSION['xid'] )
			);
			//echo $wpdb->last_query;
			?>
			<div id="message" class="updated"><p><?php echo $lbg_vp1_html5_messages['data_saved'];?></p></div>
	<?php 
		}
	}
	

	
	//echo "WP_PLUGIN_URL: ".WP_PLUGIN_URL;
	$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."lbg_vp1_html5_videosettings) WHERE id = %d",$_SESSION['xid'] );
	$row = $wpdb->get_row($safe_sql,ARRAY_A);
	$row=lbg_vp1_html5_unstrip_array($row);
	$_POST = $row; 
	$_POST=lbg_vp1_html5_unstrip_array($_POST);
		
	//echo "playerWidth: ".$row['playerWidth'];
	include_once($lbg_vp1_html5_path . 'tpl/settings_form.php');
	
}



function lbg_vp1_html5_video_player_help_page()
{
	//include_once(plugins_url('tpl/help.php', __FILE__));
	include_once($lbg_vp1_html5_path . 'tpl/help.php');
}


function lbg_vp1_html5_generate_preview_code($sliderID,$the_arr) {
	global $wpdb;
	global $post;
	
	$safe_sql=$wpdb->prepare( "SELECT * FROM (".$wpdb->prefix ."lbg_vp1_html5_videosettings) WHERE id = %d",$sliderID );
	$row = $wpdb->get_row($safe_sql,ARRAY_A);
	$row=lbg_vp1_html5_unstrip_array($row);

	$path_to_plugin = WP_PLUGIN_URL.'/'.str_replace(basename( __FILE__),"",plugin_basename(__FILE__));
	$autoPlay_aux='';
	if ($row["autoPlay"])
		$autoPlay_aux='autoplay="'.$row["autoPlay"].'"';
	$loop_aux='';
	if ($row["loop"])
		$loop_aux='loop="'.$row["loop"].'"';
	$poster_aux='';
	if ($row["preview"])
		$poster_aux='poster="'.$row["preview"].'"';
	$preload_aux='';
	if ($row["preload"])
		$preload_aux='preload="'.$row["preload"].'"';


	$mp4_path=$path_to_plugin.'lbg_vp1_html5/videos/'.$row["mp4"];	
	if (strpos($row["mp4"],"http://")===0 || strpos($row["mp4"],"https://")===0) {
		$mp4_path=$row["mp4"];
	}
	
	$ogv_path=$path_to_plugin.'lbg_vp1_html5/videos/'.$row["ogv"];	
	if (strpos($row["ogv"],"http://")===0 || strpos($row["ogv"],"https://")===0) {
		$ogv_path=$row["ogv"];
	}

	$webm_path=$path_to_plugin.'lbg_vp1_html5/videos/'.$row["webm"];	
		if (strpos($row["webm"],"http://")===0 || strpos($row["webm"],"https://")===0) {
		$webm_path=$row["webm"];
	}

	$movie_aux=$row["movieTitle"];
	$desc_aux=$row["movieDesc"];


/*** OPTIONAL PARAMETERS START ***/	
	if ($the_arr['mp4_file']!='') {
		$mp4_path=$the_arr['mp4_file'];
	}
	if ($the_arr['webm_file']!='') {
		$webm_path=$the_arr['webm_file'];
	}
	if ($the_arr['preview_file']!='') {
		$poster_aux='poster="'.$the_arr['preview_file'].'"';
	}
	if ($the_arr['movie_title']!='') {
		$movie_aux=$the_arr['movie_title'];
	}
	if ($the_arr['movie_desc']!='') {
		$desc_aux=$the_arr['movie_desc'];
	}
	

	if ($the_arr['mp4_custom_field']!='') {
		$mp4_path=get_post_meta($post->ID, $the_arr['mp4_custom_field'], true);
	}
	if ($the_arr['webm_custom_field']!='') {
		$webm_path=get_post_meta($post->ID, $the_arr['webm_custom_field'], true);
	}
	if ($the_arr['preview_custom_field']!='') {
		$poster_aux='poster="'.get_post_meta($post->ID, $the_arr['preview_custom_field'], true).'"';
	}	
	if ($the_arr['movie_title_custom_field']!='') {
		$movie_aux=get_post_meta($post->ID, $the_arr['movie_title_custom_field'], true);
	}
	if ($the_arr['movie_desc_custom_field']!='') {
		$desc_aux=get_post_meta($post->ID, $the_arr['movie_desc_custom_field'], true);
	}	
	
/*** OPTIONAL PARAMETERS END ***/	


     $rand_no=mt_rand (10000,1000000);
	 $content='<script>
		jQuery(function() {
			jQuery("#vp1_html5_'.$row["id"].$rand_no.'").vp1_html5_Video({
				skin: "'.$row["skin"].'",
				autoHideControllers: '.$row["autoHideControllers"].',
				seekBarAdjust: "'.$row["seekBarAdjust"].'",
				movieTitle: "'.$movie_aux.'",
				movieDesc: "'.$desc_aux.'",
				initialVolume: "'.$row["initialVolume"].'",
				responsive: '.$row["responsive"].',
				responsiveRelativeToBrowser: '.$row["responsiveRelativeToBrowser"].',
				width100Proc: '.$row["width100Proc"].',
				height100Proc: '.$row["height100Proc"].',
				linkToGo: "'.$row["linkToGo"].'",
				target: "'.$row["target"].'"
			});	
		});
	</script>
	<div class="vp1_html5">
            <video id="vp1_html5_'.$row["id"].$rand_no.'" width="'.$row["playerWidth"].'" height="'.$row["playerHeight"].'" '.$preload_aux.' '.$autoPlay_aux.' '.$loop_aux.' '.$poster_aux.'>
			   <source src="'.$mp4_path.'"  type=\'video/mp4; codecs="avc1.42E01E, mp4a.40.2"\' />
               <source src="'.$webm_path.'" type=\'video/webm; codecs="vp8, vorbis"\' />
            </video>
   </div>         
   <br style="clear:both;">';
   
   
   return str_replace("\r\n", '', $content);
   
}


function lbg_vp1_html5_shortcode($atts, $content=null) {
	global $wpdb;
	
	shortcode_atts( array(
		'settings_id'=>'',
		'mp4_file'=>'',
		'webm_file'=>'',
		'preview_file'=>'',
		'movie_title'=>'',
		'movie_desc'=>'',
		'mp4_custom_field'=>'',
		'webm_custom_field'=>'',
		'preview_custom_field'=>'',
		'movie_title_custom_field'=>'',
		'movie_desc_custom_field'=>''
	), $atts);
	if ($atts['settings_id']=='')
		$atts['settings_id']=1;
	/*if ($atts['mp4_file']=='')
		$atts['mp4_file']=1;	
	if ($atts['webm_file']=='')
		$atts['webm_file']=1;	
	if ($atts['mp4_custom_field']=='')
		$atts['mp4_custom_field']=1;	
	if ($atts['webm_custom_field']=='')
		$atts['webm_custom_field']=1;*/	

	return lbg_vp1_html5_generate_preview_code($atts['settings_id'],$atts);	

}



register_activation_hook(__FILE__,"lbg_vp1_html5_activate"); //activate plugin and create the database
register_uninstall_hook(__FILE__, 'lbg_vp1_html5_uninstall'); // on unistall delete all databases 
add_action('init', 'lbg_vp1_html5_video_init_sessions');	// initialize sessions
add_action('init', 'lbg_vp1_html5_video_load_styles');	// loads required styles
add_action('init', 'lbg_vp1_html5_video_load_scripts');			// loads required scripts  
add_action('admin_menu', 'lbg_vp1_html5_plugin_menu'); // create menus
add_shortcode('lbg_vp1_html5', 'lbg_vp1_html5_shortcode');				// LBG VP1 HTML5 shortcode 









/** OTHER FUNCTIONS **/

//stripslashes for an entire array
function lbg_vp1_html5_unstrip_array($array){
	if (is_array($array)) {
		foreach($array as &$val){
			if(is_array($val)){
				$val = unstrip_array($val);
			} else {
				$val = stripslashes($val);
				
			}
		}
	}
	return $array;
}



/* ajax  */

add_action('admin_head', 'lbg_vp1_html5_update_playlist_record_javascript');

function lbg_vp1_html5_update_playlist_record_javascript() {
	
	//Set Your Nonce
	$lbg_vp1_html5_preview_record_ajax_nonce = wp_create_nonce("lbg_vp1_html5_preview_record-special-string");
	if(strpos($_SERVER['PHP_SELF'], 'wp-admin') !== false) {
		$page = (isset($_GET['page'])) ? $_GET['page'] : '';
		if(preg_match('/LBG_VP1_HTML5/i', $page)) {	
?>

<script type="text/javascript" >

function showDialogPreview(theSliderID) {  //load content and open dialog
	var data ="action=lbg_vp1_html5_preview_record&security=<?php echo $lbg_vp1_html5_preview_record_ajax_nonce; ?>&theSliderID="+theSliderID;
	
	// since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php
	jQuery.post(ajaxurl, data, function(response) {
		//jQuery("#previewDialog").html(response);
		jQuery('#previewDialogIframe').attr('src','<?php echo plugins_url("tpl/preview.html?d=".time(), __FILE__)?>');
		jQuery("#previewDialog").dialog("open");
	});
}


jQuery(document).ready(function($) {
	/*PREVIEW DIALOG BOX*/
	jQuery( "#previewDialog" ).dialog({
	  minWidth:1200,
	  minHeight:500,
	  title:"Slider Preview",
	  modal: true,
	  autoOpen:false,
	  hide: "fade",
	  resizable: false,
	  open: function() {
		//jQuery( this ).html();
	  },
	  close: function() {
		//jQuery("#previewDialog").html('');
		jQuery('#previewDialogIframe').attr('src','');
	  }
	});		
	


	
});
</script>
<?php
		}
	}
} 
	


add_action('wp_ajax_lbg_vp1_html5_preview_record', 'lbg_vp1_html5_preview_record_callback');

function lbg_vp1_html5_preview_record_callback() {
	check_ajax_referer( 'lbg_vp1_html5_preview_record-special-string', 'security' );
	$the_arr=array();
	//echo lbg_vp1_html5_generate_preview_code($_POST['theSliderID']);
	$aux_val='<html>
					<head>
						<link href="'.plugins_url('lbg_vp1_html5/css/vp1_html5.css', __FILE__).'" rel="stylesheet" type="text/css">

						<script src="http://ajax.googleapis.com/ajax/libs/jquery/1.11.0/jquery.min.js" type="text/javascript"></script>
						<script src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.10.4/jquery-ui.min.js"></script>
						<script src="'.plugins_url('lbg_vp1_html5/js/vp1_html5.js', __FILE__).'" type="text/javascript"></script>
						<script src="'.plugins_url('lbg_vp1_html5/js/screenfull.min.js', __FILE__).'" type="text/javascript"></script>						
					</head>
					<body style="padding:0px;margin:0px;">';
						
	$aux_val.=lbg_vp1_html5_generate_preview_code($_POST['theSliderID'],$the_arr);
	$aux_val.="</body>
				</html>";
	$filename=plugin_dir_path(__FILE__) . 'tpl/preview.html';
	$fp = fopen($filename, 'w+');
	$fwrite = fwrite($fp, $aux_val);
	
	echo $fwrite;
	
	die(); // this is required to return a proper result
}	
	
	
	
?>