<?php
 class Services_Capsule extends Services_Capsule_Common { protected $sections = array(); public function __construct($appName, $token) { $this->token = $token; $this->appName = $appName; } public function __get($section) { $section = ucwords(strtolower($section)); switch ($section) { case 'Kase': case 'Opportunity': case 'Organization': case 'Party': case 'Person': case 'Resource': case 'Task': if (!isset($this->sections[$section])) { $classname = 'Services_Capsule_' .$section; if (!class_exists($classname)) { $filename = str_replace('_', '/', $classname) . '.php'; if (!(include $filename)) { throw new Services_Capsule_RuntimeException( 'File ' . $filename . ' does not exist.' ); } } $this->sections[$section] = new $classname; $this->sections[$section] ->setToken($this->token) ->setAppName($this->appName) ->setModuleName(strtolower($section)); } return $this->sections[$section]; break; default: throw new Services_Capsule_RuntimeException( 'Section '. $section .' is not a valid API call. If you believe this ' . 'is wrong please report a bug on http://pear.php.net/Services_Capsule' ); } } } class Services_Capsule_Organization extends Services_Capsule_Common { public function add(array $fields) { $url = ''; $org = array('organization' => $fields); $response = $this->sendRequest( $url, HTTP_Request2::METHOD_POST, json_encode($org) ); return $this->parseResponse($response); } public function update($organizationId, array $fields) { $url = '/' . (double)$organizationId; $organization = array('organization' => $fields); $response = $this->sendRequest( $url, HTTP_Request2::METHOD_PUT, json_encode($person) ); return $this->parseResponse($response); } } class Services_Capsule_Kase extends Services_Capsule_Common { public function get($id) { $response = $this->sendRequest('/' . (double)$id); return $this->parseResponse($response); } public function getList($start = null, $limit = null) { $request = array(); if (!is_null($start)) { $request['start'] = $start; } if (!is_null($limit)) { $request['limit'] = $limit; } $request = http_build_query($request); $response = $this->sendRequest('?' . $request); return $this->parseResponse($response); } public function getAny(array $params) { $request = http_build_query($params); $response = $this->sendRequest('?' . $request); return $this->parseResponse($response); } public function delete($caseId) { $url = '/' . (double)$caseId; $response = $this->sendRequest($url, HTTP_Request2::METHOD_DELETE); return $this->parseResponse($response); } } interface Services_Capsule_Exception {} class Services_Capsule_RuntimeException extends RuntimeException implements Services_Capsule_Exception {} class Services_Capsule_UnexpectedValueException extends UnexpectedValueException implements Services_Capsule_Exception {} class Services_Capsule_Kase_Tag extends Services_Capsule_Common { public function getAll($caseId) { $url = '/' . (double)$caseId . '/tag'; $response = $this->sendRequest($url); return $this->parseResponse($response); } public function add($caseId, $tagName) { $url = '/' . (double)$caseId . '/tag/' . urlencode($tagName); $response = $this->sendRequest($url, HTTP_Request2::METHOD_POST); return $this->parseResponse($response); } public function delete($caseId, $tagName) { $url = '/' . (double)$caseId . '/tag/' . urlencode($tagName); $response = $this->sendRequest($url, HTTP_Request2::METHOD_DELETE); return $this->parseResponse($response); } } class Services_Capsule_Kase_Task extends Services_Capsule_Common { public function getAll($kaseId) { $url = '/' . (double)$kaseId . '/tasks'; $response = $this->sendRequest($url); return $this->parseResponse($response); } public function add($kaseId, $fields) { $url = '/' . (double)$kaseId . '/task'; $task = array('task' => $fields); $response = $this->sendRequest( $url, HTTP_Request2::METHOD_POST, json_encode($task) ); return $this->parseResponse($response); } } class Services_Capsule_Opportunity extends Services_Capsule_Common { public function get($id) { $response = $this->sendRequest('/' . (double)$id); return $this->parseResponse($response); } public function getList($start = null, $limit = null) { $request = array(); if (!is_null($start)) { $request['start'] = $start; } if (!is_null($limit)) { $request['limit'] = $limit; } $request = http_build_query($request); $response = $this->sendRequest('?' . $request); return $this->parseResponse($response); } public function getAny(array $params) { $request = http_build_query($params); $response = $this->sendRequest('?' . $request); return $this->parseResponse($response); } public function delete($opportunityId) { $url = '/' . (double)$opportunityId; $response = $this->sendRequest($url, HTTP_Request2::METHOD_DELETE); return $this->parseResponse($response); } } class Services_Capsule_Opportunity_Customfield extends Services_Capsule_Common { public function getAll($opportunityId) { $url = '/' . (double)$opportunityId . '/customfield' ; $response = $this->sendRequest($url); return $this->parseResponse($response); } public function getDefinitions() { $response = $this->sendRequest('/customfield/definitions'); return $this->parseResponse($response); } public function add($caseId, array $fields) { if (!isset($fields['boolean'])) { throw new Services_Capsule_RuntimeException( '"boolean" parameter of second parameter required ' . 'Ex: ("boolean" => "true")' ); } $url = '/' . (double)$caseId . '/customfield'; $customField = array('customField' => $fields); $response = $this->sendRequest( $url, HTTP_Request2::METHOD_POST, json_encode($customField) ); return $this->parseResponse($response); } public function update($caseId, $fieldId, $fields) { $url = '/' . (double)$caseId . '/customfield/ ' . (double)$fieldId; $customField = array('customField' => $fields); $response = $this->sendRequest( $url, HTTP_Request2::METHOD_PUT, json_encode($customField) ); return $this->parseResponse($response); } public function delete($caseId, $fieldId) { $url = '/' . (double)$caseId . '/customfield/ ' . (double)$fieldId; $response = $this->sendRequest($url, HTTP_Request2::METHOD_DELETE); return $this->parseResponse($response); } } class Services_Capsule_Opportunity_History extends Services_Capsule_Common { public function getAll($opportunityId) { $url = '/' . (double)$opportunityId . '/history'; $response = $this->sendRequest($url); return $this->parseResponse($response); } public function addNote($opportunityId, $note) { $url = '/' . (double)$opportunityId . '/history'; $note = array( 'historyItem' => array( 'note' => $note ), ); $response = $this->sendRequest( $url, HTTP_Request2::METHOD_POST, json_encode($note) ); return $this->parseResponse($response); } public function updateNote($opportunityId, $historyId, $note) { $url = '/' . (double)$opportunityId . '/history/' . (double)$historyId; $note = array( 'historyItem' => array( 'note' => $note ), ); $response = $this->sendRequest($url, HTTP_Request2::METHOD_PUT, json_encode($note)); return $this->parseResponse($response); } public function deleteNote($opportunityId, $historyId) { $url = '/' . (double)$opportunityId . '/history/' . (double)$historyId; $response = $this->sendRequest($url, HTTP_Request2::METHOD_DELETE); return $this->parseResponse($response); } } class Services_Capsule_Opportunity_Tag extends Services_Capsule_Common { public function getAll($opportunityId) { $url = '/' . (double)$opportunityId . '/tag'; $response = $this->sendRequest($url); return $this->parseResponse($response); } public function add($opportunityId, $tagName) { $url = '/' . (double)$opportunityId . '/tag/' . urlencode($tagName); $response = $this->sendRequest($url, HTTP_Request2::METHOD_POST); return $this->parseResponse($response); } public function delete($opportunityId, $tagName) { $url = '/' . (double)$opportunityId . '/tag/' . urlencode($tagName); $response = $this->sendRequest($url, HTTP_Request2::METHOD_DELETE); return $this->parseResponse($response); } } class Services_Capsule_Opportunity_Task extends Services_Capsule_Common { public function getAll($opportunityId) { $url = '/' . (double)$opportunityId . '/tasks'; $response = $this->sendRequest($url); return $this->parseResponse($response); } public function add($opportunityId, $fields) { $url = '/' . (double)$opportunityId . '/task'; $task = array('task' => $fields); $response = $this->sendRequest( $url, HTTP_Request2::METHOD_POST, json_encode($task) ); return $this->parseResponse($response); } } class Services_Capsule_Opportunity_Party extends Services_Capsule_Common { public function getAll($opportunityId) { $url = '/' . (double)$opportunityId . '/party'; $response = $this->sendRequest($url); return $this->parseResponse($response); } public function add($opportunityId, $partyId) { $url = '/' . (double)$opportunityId . '/party/' . (double)$partyId; $response = $this->sendRequest($url, HTTP_Request2::METHOD_POST); return $this->parseResponse($response); } public function delete($opportunityId, $partyId) { $url = '/' . (double)$opportunityId . '/party/' . (double)$partyId; $response = $this->sendRequest($url, HTTP_Request2::METHOD_DELETE); return $this->parseResponse($response); } } class Services_Capsule_Opportunity_Milestone extends Services_Capsule_Common { public function getAll($partyId) { $response = $this->sendRequest('/milestones'); return $this->parseResponse($response); } } class Services_Capsule_Party_Customfield extends Services_Capsule_Common { public function get($partyId, $fieldName) { $url = '/' . (double)$partyId . '/' . $fieldName; $response = $this->sendRequest($url); return $this->parseResponse($response); } public function getDefinitions() { $response = $this->sendRequest('/customfield/definitions'); return $this->parseResponse($response); } public function add($partyId, array $fields) { if (!isset($fields['boolean'])) { throw new Services_Capsule_RuntimeException( '"boolean" parameter of second parameter required ' . 'Ex: ("boolean" => "true")' ); } $url = '/' . (double)$partyId . '/customfield'; $customField = array('customField' => $fields); $response = $this->sendRequest( $url, HTTP_Request2::METHOD_POST, json_encode($customField) ); return $this->parseResponse($response); } public function update($partyId, $fieldId, $fields) { $url = '/' . (double)$partyId . '/customfield/ ' . (double)$fieldId; $customField = array('customField' => $fields); $response = $this->sendRequest( $url, HTTP_Request2::METHOD_PUT, json_encode($customField) ); return $this->parseResponse($response); } public function delete($partyId, $fieldId) { $url = '/' . (double)$partyId . '/customfield/ ' . (double)$fieldId; $response = $this->sendRequest($url, HTTP_Request2::METHOD_DELETE); return $this->parseResponse($response); } } class Services_Capsule_Party_People extends Services_Capsule_Common { public function getAll($partyId) { $url = '/' . (double)$partyId . '/people'; $response = $this->sendRequest($url); return $this->parseResponse($response); } } class Services_Capsule_Party_History extends Services_Capsule_Common { public function getAll($partyId) { $url = '/' . (double)$partyId . '/history'; $response = $this->sendRequest($url); return $this->parseResponse($response); } public function addNote($partyId, $note) { $url = '/' . (double)$partyId . '/history'; $note = array( 'historyItem' => array( 'note' => $note ), ); $response = $this->sendRequest($url, HTTP_Request2::METHOD_POST, json_encode($note)); return $this->parseResponse($response); } public function updateNote($partyId, $historyId, $note) { $url = '/' . (double)$partyId . '/history/' . (double)$historyId; $note = array( 'historyItem' => array( 'note' => $note ), ); $response = $this->sendRequest($url, HTTP_Request2::METHOD_PUT, json_encode($note)); return $this->parseResponse($response); } public function deleteNote($partyId, $historyId) { $url = '/' . (double)$partyId . '/history/' . (double)$historyId; $response = $this->sendRequest($url, HTTP_Request2::METHOD_DELETE); return $this->parseResponse($response); } } class Services_Capsule_Party_Opportunity extends Services_Capsule_Common { public function getAll($partyId) { $url = '/' . (double)$partyId . '/opportunity'; $response = $this->sendRequest($url); return $this->parseResponse($response); } public function add($partyId, $fields) { $url = '/' . (double)$partyId . '/opportunity'; $opportunity = array('opportunity' => $fields); $response = $this->sendRequest( $url, HTTP_Request2::METHOD_POST, json_encode($opportunity) ); return $this->parseResponse($response); } public function update($partyId, $fields) { $url = '/' . (double)$partyId . '/opportunity'; $opportunity = array('opportunity' => $fields); $response = $this->sendRequest( $url, HTTP_Request2::METHOD_PUT, json_encode($opportunity) ); return $this->parseResponse($response); } } class Services_Capsule_Party_Tag extends Services_Capsule_Common { public function getAll($partyId) { $url = '/' . (double)$partyId . '/tag'; $response = $this->sendRequest($url); return $this->parseResponse($response); } public function add($partyId, $tagName) { $url = '/' . (double)$partyId . '/tag/' . urlencode($tagName); $response = $this->sendRequest($url, HTTP_Request2::METHOD_POST); return $this->parseResponse($response); } public function delete($partyId, $tagName) { $url = '/' . (double)$partyId . '/tag/' . urlencode($tagName); $response = $this->sendRequest($url, HTTP_Request2::METHOD_DELETE); return $this->parseResponse($response); } } class Services_Capsule_Party_Cases extends Services_Capsule_Common { public function getAll($partyId) { $url = '/' . (double)$partyId . '/kase'; $response = $this->sendRequest($url); return $this->parseResponse($response); } public function add($partyId, array $fields) { $url = '/' . (double)$partyId . '/kase'; $case = array('kase' => $fields); $response = $this->sendRequest( $url, HTTP_Request2::METHOD_POST, json_encode($case) ); return $this->parseResponse($response); } public function update($partyId, $fieldId, $fields) { $url = '/' . (double)$partyId . '/kase/ ' . (double)$caseId; $case = array('kase' => $fields); $response = $this->sendRequest( $url, HTTP_Request2::METHOD_PUT, json_encode($case) ); return $this->parseResponse($response); } } class Services_Capsule_Party_Task extends Services_Capsule_Common { public function getAll($partyId) { $url = '/' . (double)$partyId . '/tasks'; $response = $this->sendRequest($url); return $this->parseResponse($response); } public function add($partyId, $fields) { $url = '/' . (double)$partyId . '/task'; $task = array('task' => $fields); $response = $this->sendRequest( $url, HTTP_Request2::METHOD_POST, json_encode($task) ); return $this->parseResponse($response); } } class Services_Capsule_Resource extends Services_Capsule_Common { public function getCountries() { $response = $this->sendRequest('/country'); return $this->parseResponse($response); } public function getCurrencies() { $response = $this->sendRequest('/currency'); return $this->parseResponse($response); } } class Services_Capsule_Person extends Services_Capsule_Common { public function add(array $fields) { $url = ''; $person = array('person' => $fields); $response = $this->sendRequest( $url, HTTP_Request2::METHOD_POST, json_encode($person) ); return $this->parseResponse($response); } public function update($personId, array $fields) { $url = '/' . (double)$personId; $person = array('person' => $fields); $response = $this->sendRequest( $url, HTTP_Request2::METHOD_PUT, json_encode($person) ); return $this->parseResponse($response); } } class Services_Capsule_Task extends Services_Capsule_Common { public function get($id) { $response = $this->sendRequest('/' . (double)$id); return $this->parseResponse($response); } public function getList($start = null, $limit = null, $category = null, $user = null) { $request = array(); if (!is_null($start)) { $request['start'] = $start; } if (!is_null($limit)) { $request['limit'] = $limit; } if (!is_null($category)) { $request['category'] = $category; } if (!is_null($user)) { $request['user'] = $user; } $request = http_build_query($request); $response = $this->sendRequest('s?' . $request); return $this->parseResponse($response); } public function complete($taskId) { $url = '/' . (double)$taskId . '/complete'; $response = $this->sendRequest( $url, HTTP_Request2::METHOD_POST ); return $this->parseResponse($response); } public function reopen($taskId) { $url = '/' . (double)$taskId . '/repoen'; $response = $this->sendRequest( $url, HTTP_Request2::METHOD_POST ); return $this->parseResponse($response); } public function add($fields) { $url = ''; $task = array('task' => $fields); $response = $this->sendRequest( $url, HTTP_Request2::METHOD_POST, json_encode($task) ); return $this->parseResponse($response); } public function update($taskId, array $fields) { $url = '/' . (double)$taskId; $task = array('task' => $fields); $response = $this->sendRequest( $url, HTTP_Request2::METHOD_PUT, json_encode($task) ); return $this->parseResponse($response); } public function delete($taskId) { $url = '/' . (double)$taskId; $response = $this->sendRequest($url, HTTP_Request2::METHOD_DELETE); return $this->parseResponse($response); } } class Services_Capsule_Party extends Services_Capsule_Common { public function get($id) { $response = $this->sendRequest('/' . (double)$id); return $this->parseResponse($response); } public function getList($start = null, $limit = null) { $request = array(); if (!is_null($start)) { $request['start'] = $start; } if (!is_null($limit)) { $request['limit'] = $limit; } $request = http_build_query($request); $response = $this->sendRequest('?' . $request); return $this->parseResponse($response); } public function search($term, $start = null, $limit = null) { $request = array(); $request['q'] = $term; if (!is_null($start)) { $request['start'] = $start; } if (!is_null($limit)) { $request['limit'] = $limit; } $request = http_build_query($request); $response = $this->sendRequest('?' . $request); return $this->parseResponse($response); } public function getAny(array $params) { $request = http_build_query($params); $response = $this->sendRequest('?' . $request); return $this->parseResponse($response); } public function delete($partyId) { $url = '/' . (double)$partyId; $response = $this->sendRequest($url, HTTP_Request2::METHOD_DELETE); return $this->parseResponse($response); } } abstract class Services_Capsule_Common { protected $subSections = array(); protected $moduleName; protected $token; protected $appName; protected $client; protected $endpoint = 'https://%s.capsulecrm.com/api/%s'; public function __get($section) { $section = ucwords(strtolower($section)); switch ($section) { case 'Customfield': case 'History': case 'Milestone': case 'Opportunity': case 'Tag': case 'Task': case 'Party': $currentModule = ucfirst(strtolower($this->moduleName)); if (!isset($this->subSections[$section])) { $classname = 'Services_Capsule_'. $currentModule . '_' .$section; if (!class_exists($classname)) { $filename = str_replace('_', '/', $classname) . '.php'; if (!(include $filename)) { throw new Services_Capsule_RuntimeException( 'File ' . $filename . ' does not exist.' ); } } $this->subSections[$section] = new $classname; } $this->subSections[$section] ->setToken($this->token) ->setAppName($this->appName) ->setModuleName(strtolower($currentModule)); return $this->subSections[$section]; break; default: throw new Services_Capsule_RuntimeException( 'Section '. $section .' is not a valid API call. If you believe this ' . 'is wrong please report a bug on http://pear.php.net/Services_Capsule' ); } } public function setToken($token) { $this->token = $token; return $this; } public function setAppName($appName) { $this->appName = $appName; return $this; } public function setModuleName($moduleName) { $this->moduleName = $moduleName; return $this; } protected function sendRequest($url, $method = HTTP_Request2::METHOD_GET, $data = null) { if (!isset($this->appName)) { throw new Services_Capsule_UnexpectedValueException( 'Please set an app name.' ); } if (!isset($this->client) || !($this->client instanceof HTTP_Request2)) { $this->client = new HTTP_Request2(); $this->client->setAdapter('curl'); $z = $this->client->getConfig(); $z['ssl_verify_peer'] = false; $z['ssl_verify_host'] = false; $this->client->setConfig($z); } $finalUrl = sprintf($this->endpoint, $this->appName, $this->moduleName); $finalUrl = $finalUrl . $url; $this->client ->setHeader('Content-Type: application/json') ->setHeader('Accept: application/json') ->setAuth($this->token, 'x') ->setMethod($method) ->setUrl($finalUrl); if (!is_null($data)) { $this->client->setBody($data); } try { $response = $this->client->send(); } catch (HTTP_Request2_Exception $e) { throw new Services_Capsule_RuntimeException($e); } return $response; } protected function parseResponse(HTTP_Request2_Response $response) { $body = $response->getBody(); $return = json_decode($body); if (!($return instanceof stdClass)) { if ($response->getStatus() == 201 || $response->getStatus() == 200) { return true; } throw new Services_Capsule_RuntimeException( 'Invalid response with no valid json body' ); } return $return; } } 