<?php

require __DIR__ . '/vendor/autoload.php';
/*ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
*/


$tab = date('F Y'); // Sheet name

add_action( 'gform_after_submission', 'post_to_third_party', 10, 2 );
function post_to_third_party( $entry, $form ) {
	$client = new \Google_Client();
	$client->setApplicationName('TOTAL SEO');
	$client->setScopes([\Google_Service_Sheets::SPREADSHEETS]);
	$client->setAccessType('offline');
	$client->setAuthConfig(__DIR__ . '/credentials.json');

	$service = new Google_Service_Sheets($client);
	$spreadsheetId = '1CUqNGOLqA3pBVzlqe0mU_5ArJsZyNC4BvfaOdBxZ-jg';
	$sheets = $service->spreadsheets->get($spreadsheetId)->getSheets();
	$tabs = array();
	foreach ($sheets as $key => $sheet) {
		$tabs[] = $sheet->getProperties()->title;
	}

	if(!in_array(date('F Y'), $tabs)) {
		$body = new Google_Service_Sheets_BatchUpdateSpreadsheetRequest(
			array(
				'requests' => array(
					'addSheet' => array(
						'properties' => array(
							'title' => date('F Y')
						)
					)
				)
			)
		);
		$service->spreadsheets->batchUpdate($spreadsheetId,$body);

		$newRow = [
			'EntryId',
			'Date',
			'Website',
			'Email',
			'Name',
			'Google Ads',
			'Campaign',
			'Device',
			'Location',
			'Price',
			'Account Manager',
			'Date Chased',
			'Documents Done',
			'PhoneNumber',
			'Notes',
			'Text Messages',
			'SyncStatus',
			'ReportPDF',
			'Source',
			'IP Address',
			'ActiveCampaignId',
			'IsReturningCustomer',
			'LeadSystemId',
			'DraftTime',
			'RetryCount',
			'Social Media - Following',
			'Preview',
			'Score'
		];
		$rows = [$newRow];

		$valueRange = new \Google_Service_Sheets_ValueRange();
		$valueRange->setValues($rows);
		$options = ['valueInputOption' => 'RAW'];
		$range = date('F Y');

		$service->spreadsheets_values->append($spreadsheetId, $range, $valueRange, $options);
	}

	$range = date('F Y').'!A2:A';
	$response = $service->spreadsheets_values->get($spreadsheetId, $range);
	$value = $response->getValues();

	$new_line = (count($value) + 2);
	$entryIds = array();
	foreach ($value as $key => $item) {
		$entryIds[] = $item[0];
	}
	$entryId = rgar( $entry, 'id' );
	$valueRange = new \Google_Service_Sheets_ValueRange();
	$formId = rgar( $entry, 'form_id' );
	if($formId == 1 || $formId == 2 || $formId == 26 || $formId == 27) {
		$source_url = explode('&eid=', rgar($entry, 'source_url'));
		if($source_url[1]) {
			$entryKey = array_search($source_url[1], $entryIds);
			$entryKey = $entryKey+2;
			$date = date('Y-m-d H:i', strtotime(rgar( $entry, 'date_created' )));
			$website = $_GET['website'];
			if (substr($website, 0, 7) == 'http://' || substr($website, 0, 8) == 'https://') {
				$website = $website;
			} else {
				$website = 'https://'.$website;
			}

			$ch = curl_init($website);
			curl_setopt($ch, CURLOPT_HEADER, FALSE);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
			curl_setopt($ch, CURLOPT_MAXREDIRS, 5);
			curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
			$result = curl_exec($ch);
			curl_close($ch);

			$phoneNumbers = extract_phones_from($result);
			$phoneNumber = trim($phoneNumbers[0]);

			$sales = 'simon';
			$name = rgar( $entry, '1' );
			$name = ucfirst(explode(' ', $name)[0]);
			$email = rgar( $entry, '2' );

			if(preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"])){
				$device = 'Mobile';
			} else {
				$device = 'Desktop';
			}
			$PublicIP = get_client_ip();
			$json = file_get_contents("http://ipinfo.io/$PublicIP/geo");
			$details = json_decode($json, true);
			if($details) {
				$location = $details['city'];
			} else {
				$location = '';
			}

			$updateRow = [
				$entryId,
				$date,
				$website,
				$email,
				$name,
				'',
				'',
				$device,
				$location,
				'',
				'',
				'',
				'',
				$phoneNumber
			];
			$rows = [$updateRow];
			$valueRange->setValues($rows);
			$range = date('F Y').'!A'.$entryKey.':N'.$entryKey;
			$options = ['valueInputOption' => 'USER_ENTERED'];

			$service->spreadsheets_values->update($spreadsheetId, $range, $valueRange, $options);

			$rows = [['']];
			$valueRange->setValues($rows);
			$range = date('F Y').'!O'.$entryKey.':O';
			$service->spreadsheets_values->update($spreadsheetId, $range, $valueRange, $options);
		} else {
			$ip = rgar( $entry, 'ip' );
			$date = date('Y-m-d H:i', strtotime(rgar( $entry, 'date_created' )));
			$emailAddress = '';
			if (substr(rgar($entry, '1'), 0, 7) == 'http://' || substr(rgar($entry, '1'), 0, 8) == 'https://') {
				$website = rgar( $entry, '1' );
			} else {
				$website = 'https://'.rgar( $entry, '1' );
			}

			$ch = curl_init($website);
			curl_setopt($ch, CURLOPT_HEADER, FALSE);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
			curl_setopt($ch, CURLOPT_MAXREDIRS, 5);
			curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
			$result = curl_exec($ch);
			curl_close($ch);

			$emails = extract_emails_from($result);
			foreach ($emails as $key => $email) {
				if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
					$emailAddress = trim($email);
				}
			}

			if($emailAddress == '') {
				$ch = curl_init($website.'/contact');
				curl_setopt($ch, CURLOPT_HEADER, FALSE);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
				curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
				curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
				curl_setopt($ch, CURLOPT_MAXREDIRS, 5);
				curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
				$result = curl_exec($ch);
				curl_close($ch);

				$emails = extract_emails_from($result);
				foreach ($emails as $key => $email) {
					if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
						$emailAddress = trim($email);
					}
				}
			}

			if($emailAddress == '') {
				$ch = curl_init($website.'/contacts');
				curl_setopt($ch, CURLOPT_HEADER, FALSE);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
				curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
				curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
				curl_setopt($ch, CURLOPT_MAXREDIRS, 5);
				curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
				$result = curl_exec($ch);
				curl_close($ch);

				$emails = extract_emails_from($result);
				foreach ($emails as $key => $email) {
					if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
						$emailAddress = trim($email);
					}
				}
			}

			if($emailAddress == '') {
				$ch = curl_init($website.'/contactus');
				curl_setopt($ch, CURLOPT_HEADER, FALSE);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
				curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
				curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
				curl_setopt($ch, CURLOPT_MAXREDIRS, 5);
				curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
				$result = curl_exec($ch);
				curl_close($ch);

				$emails = extract_emails_from($result);
				foreach ($emails as $key => $email) {
					if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
						$emailAddress = trim($email);
					}
				}
			}

			if($emailAddress == '') {
				$ch = curl_init($website.'/contact-us');
				curl_setopt($ch, CURLOPT_HEADER, FALSE);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
				curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
				curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
				curl_setopt($ch, CURLOPT_MAXREDIRS, 5);
				curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
				$result = curl_exec($ch);
				curl_close($ch);

				$emails = extract_emails_from($result);
				foreach ($emails as $key => $email) {
					if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
						$emailAddress = trim($email);
					}
				}
			}

			if($emailAddress == '') {
				$ch = curl_init($website.'/pages/contact');
				curl_setopt($ch, CURLOPT_HEADER, FALSE);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
				curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
				curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
				curl_setopt($ch, CURLOPT_MAXREDIRS, 5);
				curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
				$result = curl_exec($ch);
				curl_close($ch);

				$emails = extract_emails_from($result);
				foreach ($emails as $key => $email) {
					if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
						$emailAddress = trim($email);
					}
				}
			}

			$sales = 'simon';
			if(preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"])){
				$device = 'Mobile';
			} else {
				$device = 'Desktop';
			}
			$PublicIP = get_client_ip();
			$json = file_get_contents("http://ipinfo.io/$PublicIP/geo");
			$details = json_decode($json, true);
			if($details) {
				$location = $details['city'];
			} else {
				$location = '';
			}
			$source = rgar( $entry, 'source_url' );
			$newRow = [
				$entryId,
				$date,
				$website,
				$emailAddress,
				'',
				'',
				'',
				$device,
				$location,
				'',
				'',
				'',
				'',
				'',
				'WebsiteOnly',
				'',
				'',
				'',
				$source,
				$ip
			];
			$rows = [$newRow];
			$options = ['valueInputOption' => 'RAW'];
			$range = date('F Y');
			$valueRange = new \Google_Service_Sheets_ValueRange();
			$valueRange->setValues($rows);

			try {
				$service->spreadsheets_values->append($spreadsheetId, $range, $valueRange, $options);
			} catch (\Throwable $th) {
				file_put_contents(__DIR__ . 'sheets.log', date('c').' - CAPTURE RESPONSE: '.json_encode($th).PHP_EOL.PHP_EOL , FILE_APPEND);
				//throw $th;
			}
		}
	} else if($formId == 8) {
		$ip = rgar( $entry, 'ip' );
		$date = date('Y-m-d H:i', strtotime(rgar( $entry, 'date_created' )));
		$email = rgar($entry, '1');
		if (substr(rgar($entry, '2'), 0, 7) == 'http://' || substr(rgar($entry, '2'), 0, 8) == 'https://') {
			$website = rgar( $entry, '2' );
		} else {
			$website = 'https://'.rgar( $entry, '2' );
		}

		$ch = curl_init($website);
		curl_setopt($ch, CURLOPT_HEADER, FALSE);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
		curl_setopt($ch, CURLOPT_MAXREDIRS, 5);
		curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
		$result = curl_exec($ch);
		curl_close($ch);

		$phoneNumbers = extract_phones_from($result);
		$phoneNumber = trim($phoneNumbers[0]);

		$sales = 'simon';
		if(preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"])){
			$device = 'Mobile';
		} else {
			$device = 'Desktop';
		}
		$PublicIP = get_client_ip();
		$json = file_get_contents("http://ipinfo.io/$PublicIP/geo");
		$details = json_decode($json, true);
		if($details) {
			$location = $details['city'];
		} else {
			$location = '';
		}
		$source = rgar( $entry, 'source_url' );
		$newRow = [
			$entryId,
			$date,
			$website,
			$email,
			'',
			'',
			'',
			$device,
			$location,
			'',
			'',
			'',
			'',
			$phoneNumber,
			'',
			'',
			'',
			'',
			$source,
			$ip
		];
		$rows = [$newRow];
		$options = ['valueInputOption' => 'USER_ENTERED'];
		$range = date('F Y');
		$valueRange = new \Google_Service_Sheets_ValueRange();
		$valueRange->setValues($rows);

		$service->spreadsheets_values->append($spreadsheetId, $range, $valueRange, $options);
	} else if($formId == 24) {
		$ip = rgar( $entry, 'ip' );
		$date = date('Y-m-d H:i', strtotime(rgar( $entry, 'date_created' )));
		$email = rgar($entry, '2');
		if (substr(rgar($entry, '1'), 0, 7) == 'http://' || substr(rgar($entry, '1'), 0, 8) == 'https://') {
			$website = rgar( $entry, '1' );
		} else {
			$website = 'https://'.rgar( $entry, '1' );
		}

		$ch = curl_init($website);
		curl_setopt($ch, CURLOPT_HEADER, FALSE);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
		curl_setopt($ch, CURLOPT_MAXREDIRS, 5);
		curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
		$result = curl_exec($ch);
		curl_close($ch);

		$phoneNumbers = extract_phones_from($result);
		$phoneNumber = trim($phoneNumbers[0]);

		$sales = 'simon';
		if(preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"])){
			$device = 'Mobile';
		} else {
			$device = 'Desktop';
		}
		$PublicIP = get_client_ip();
		$json = file_get_contents("http://ipinfo.io/$PublicIP/geo");
		$details = json_decode($json, true);
		if($details) {
			$location = $details['city'];
		} else {
			$location = '';
		}
		$source = rgar( $entry, 'source_url' );
		$newRow = [
			$entryId,
			$date,
			$website,
			$email,
			'',
			'',
			'',
			$device,
			$location,
			'',
			'',
			'',
			'',
			$phoneNumber,
			'',
			'',
			'',
			'',
			$source,
			$ip
		];
		$rows = [$newRow];
		$options = ['valueInputOption' => 'USER_ENTERED'];
		$range = date('F Y');
		$valueRange = new \Google_Service_Sheets_ValueRange();
		$valueRange->setValues($rows);

		$service->spreadsheets_values->append($spreadsheetId, $range, $valueRange, $options);
	}

	GFCommon::log_debug( 'gform_after_submission: body => ' . print_r( $rows, true ) );
}

function get_client_ip() {
	$ipaddress = '';
	// Check for HTTP_CF_CONNECTING_IP first (Cloudflare)
	if (isset($_SERVER['HTTP_CF_CONNECTING_IP'])) {
		$ipaddress = $_SERVER['HTTP_CF_CONNECTING_IP'];
	}
	// Check for HTTP_CLIENT_IP first
	elseif (!empty($_SERVER['HTTP_CLIENT_IP'])) {
		$ipaddress = $_SERVER['HTTP_CLIENT_IP'];
	}
	// Check for HTTP_X_FORWARDED_FOR
	elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
		$ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
		// In case of multiple IPs, take the first one (original client)
		$ip_list = explode(',', $ipaddress);
		$ipaddress = trim($ip_list[0]);
	}
	// Check for HTTP_X_REAL_IP
	elseif (!empty($_SERVER['HTTP_X_REAL_IP'])) {
		$ipaddress = $_SERVER['HTTP_X_REAL_IP'];
	}
	// Fallback to REMOTE_ADDR
	else {
		$ipaddress = $_SERVER['REMOTE_ADDR'];
	}

	// Optional: Validate the IP address
	if (filter_var($ipaddress, FILTER_VALIDATE_IP)) {
		return $ipaddress; // Return the valid IP address
		//return $_SERVER['REMOTE_ADDR']; // Fallback to REMOTE_ADDR if needed
	} else {
		return 'UNKNOWN'; // Or handle invalid IP as needed
	}
}

function extract_emails_from($string) {
	preg_match_all("/[\._a-zA-Z0-9-]+@[\._a-zA-Z0-9-]+/i", $string, $matches);
	return $matches[0];
}

function extract_phones_from($string) {
	preg_match_all("/\(?(0)?([0-9]{3})\s*\)?\s*-?\s*([0-9]{3})\s*-?\s*([0-9]{4})/g", $string, $matches);
	return $matches[0];
}