<?php

namespace CleantalkSP\SpbctWP\Scanner\ScanningStagesModule\Stages;

use CleantalkSP\SpbctWP\DB\ObjectForOptionsInterface;

class DBTriggerAnalysis extends ScanningStageAbstract implements ObjectForOptionsInterface
{
    public $scanned_count_files = 0;

    /** @psalm-suppress PossiblyUnusedMethod */
    public static function getTitle()
    {
        return __('DB Trigger Analysis', 'security-malware-firewall');
    }

    /** @psalm-suppress PossiblyUnusedMethod */
    public function getDescription()
    {
        return __('Scanned database triggers ', 'security-malware-firewall')
               . $this->scanned_count_files
               . '.';
    }

    public function getName()
    {
        return __CLASS__;
    }

    public function getData()
    {
        return array();
    }
}
