<?php

namespace CleantalkSP\SpbctWP\Scanner\ScanningLog;

class ScanningLogFacade
{
    public static function writeToLog($content)
    {
        return Repository::write($content);
    }

    public static function clearLog()
    {
        return Repository::clear();
    }

    /**
     * Render the scanning log
     *
     * @param int $limit
     * @param int $offset
     * @return string
     */
    public static function render($limit = 100, $offset = 0, $only_rows = false)
    {
        $data = Repository::getAll($limit, $offset);

        if (!empty($data)) {
            return $only_rows ? Template::generateRows($data) : Template::render($data, $offset);
        }

        return '';
    }

    /**
     * Get data for PDF
     * @psalm-suppress PossiblyUnusedMethod
     */
    public static function getForPDF()
    {
        $data = Repository::getAll();

        if (!empty($data)) {
            return array_reverse($data);
        }
    }
}
