<?php

/**
 * Class for handling scanner files data in the database. Only for set, update, delete operations.
 * For reading data use ScanRepository class.
 */

namespace CleantalkSP\SpbctWP\Scanner;

class ScanStorage
{
    /**
     * Set file as pending queue
     *
     * @param string $fast_hash
     * @return bool
     */
    public static function setFileAsPendingQueue($fast_hash)
    {
        global $wpdb;

        $sql = $wpdb->prepare(
            'UPDATE ' . SPBC_TBL_SCAN_FILES
            . ' SET'
            . ' last_sent = ' . current_time('timestamp') . ','
            . ' pscan_pending_queue = 1'
            . ' WHERE fast_hash = %s',
            $fast_hash
        );

        return $wpdb->query($sql);
    }

    /**
     * Update file as sent successfully
     *
     * @param string $fast_hash
     * @param string $file_id
     * @return bool
     */
    public static function updateSendFileStatusAsSuccess($fast_hash, $file_id)
    {
        global $wpdb;

        $sql = $wpdb->prepare(
            'UPDATE ' . SPBC_TBL_SCAN_FILES
            . ' SET'
            . ' last_sent = ' . current_time('timestamp') . ','
            . ' pscan_processing_status = "NEW",'
            . ' pscan_pending_queue = 0,'
            . ' pscan_file_id = %s'
            . ' WHERE fast_hash = %s',
            $file_id,
            $fast_hash
        );

        return $wpdb->query($sql);
    }

    /**
     * Set file as not pending queue
     *
     * @param string $fast_hash
     * @return void
     */
    public static function setFileAsNotPendingQueue($fast_hash)
    {
        global $wpdb;

        $update_sql = $wpdb->prepare(
            'UPDATE ' . SPBC_TBL_SCAN_FILES
            . ' SET '
            . 'pscan_pending_queue = 0 '
            . 'WHERE fast_hash = %s',
            $fast_hash
        );

        $wpdb->query($update_sql);
    }
}
