<?php

namespace CleantalkSP\SpbctWP\Scanner\DBTrigger;

use CleantalkSP\SpbctWP\ListTable;

final class DBTriggerView
{
    /**
     * @param ListTable $table
     *
     * @return ListTable
     */
    final public static function prepareTableData($table)
    {
        $table->items = DBTriggerService::loadTriggersStorage();
        $table->items_count = DBTriggerService::countTriggersStorage();
        $table->columns = [
            'cb'         => array('heading' => '<input type=checkbox>', 'class' => 'check-column',  'width_percent' => 2),
            'about_trigger'   => array( 'heading' => 'About trigger', 'width_percent' => 30 ), // name, table, time, action
            'code'            => array( 'heading' => 'Code', 'width_percent' => 43 ),
            'signature'       => array( 'heading' => 'Signature', 'width_percent' => 10 ),
            'analysis_status' => array( 'heading' => 'Verdict', 'width_percent' => 15 ),
        ];
        $table->actions = [
            'delete'  => array('name' => 'Delete',),
        ];
        foreach ($table->items as $key => $item) {
            $table->items[$key]['about_trigger'] = sprintf(
                '%s <br> %s <br> %s <br> %s',
                __('Name', 'security-malware-firewall') . ': ' . $item['name'],
                __('Table', 'security-malware-firewall') . ': ' . $item['table'],
                __('Time', 'security-malware-firewall') . ': ' . $item['time'],
                __('Action', 'security-malware-firewall') . ': ' . $item['action']
            );
            $table->items[$key]['about_trigger'] .= sprintf(
                '<div class="row-actions" uid="%s"><span class="spbct-delete-trigger-action tbl-row_action tbl-row_action--delete tbl-row_action--ajax" data-trigger-name="%s" row-action="delete-trigger">%s</span></div>',
                $item['name'],
                $item['name'],
                __('Delete', 'security-malware-firewall')
            );
            $table->items[$key]['code'] = $item['code'];
            $table->items[$key]['signature'] = $item['signature'];
            $table->items[$key]['analysis_status'] = $item['status'];
            $table->items[$key]['cb'] = 1;
        }
        return $table;
    }

    final public static function getScannerTabDescription()
    {
        return '<div>'
               .
               __('This feature scans your WordPress database tables to find suspicious schema triggers that probably may cause malware infection.', 'security-malware-firewall')
               .
               '</div>';
    }

    final public static function getWarningTextForMalwareRemovalBanner()
    {
        return __("There's a high probability that your website has been compromised, as suspicious database triggers show signs of infection. Take action now by ordering malware removal from our experienced security specialists.", 'security-malware-firewall');
    }
}
