<?php

namespace CleantalkSP\SpbctWP\FSWatcher\View;

use CleantalkSP\SpbctWP\FSWatcher\Logger;
use CleantalkSP\SpbctWP\FSWatcher\Controller;

class View
{
    public static function renderSelectors(Phrases $phrases)
    {
        $html = '<div class="spbc_tab_fields_group">';
        $html .= '<div class="spbc_group_header">';
        $html .= '<h3>' . $phrases->getTitle() . '</h3>';
        $html .= '</div>';

        $html .= '<div style="padding: 0 0 0 10px">';
        $html .= '<p>' . self::getFSWatcherDescription($phrases) . '</p>';
        $html .= '<p>' . self::getExtendedTabDescription($phrases) . '</p>';

        $storage = Controller::$storage;
        $dates = $storage::getAvailableJournals();

        $html .= self::manualSnapshotButton($phrases);

        if ( ! static::snapshotsAreReady($dates) ) {
            // Snapshots were not ready, do not render selectors
            $html .= '<p>' . $phrases->featureNotReady1() . '</p>';
            $html .= '<p>' . $phrases->featureNotReady2() . '</p>';
        }

        $display_selectors = self::snapshotsAreReady($dates) ? 'block' : 'none';
        $html .= '<div style="display:' . $display_selectors  . '">';
        $html .= '<p>' . $phrases->getCompareButtonDescription() . '</p>';
        $html .= '<div style="display: flex;flex-wrap: wrap;gap: 16px;">';

        $html .= '<div style="display: block;">';
        $html .= '<label style="display: block" for="fswatcher__first_date">' . $phrases->getFirstDateLabel() . '</label>';
        $html .= '<select name="fswatcher__first_date" id="fswatcher__first_date">';
        $html .= self::renderSelectorOptions($dates);
        $html .= '</select>';
        $html .= '</div>';

        $html .= '<div style="display: block;">';
        $html .= '<label style="display: block" for="fswatcher__second_date">' . $phrases->getSecondDateLabel() . '</label>';
        $html .= '<select name="fswatcher__second_date" id="fswatcher__second_date">';
        $html .= self::renderSelectorOptions($dates);
        $html .= '</select>';
        $html .= '</div>';

        $html .= '</div>';
        $html .= '</br>';
        $html .= '</br>';

        $html .= '<div>';
        $html .= '<button class="spbc-icon-exchange" id="fswatcher__compare">' . $phrases->getCompareButtonText() . '</button>';
        $html .= '<img style="display: none; margin-left: 10px; margin-top: 1px; width: 16px;" id="fsw_preloader_compare" src="../../wp-content/plugins/security-malware-firewall/images/preloader2.gif"';
        $html .= '</br>';
        $html .= '</br>';
        $html .= '</br>';
        $html .= '</div>';
        $html .= '</div>';

        $html .= '</div>';

        $html .= '<script type="text/javascript">';
        $html .= 'var fswatcherTranslations = ' . json_encode($phrases->getTranslations()) . ';';
        $html .= '</script>';
        $html .= '</div>';

        $html .= '</br>';

        $html .= self::renderTableTemplate($phrases);

        $html .= '<div id="spbc_dialog" title="File output" style="overflow: initial;"></div>';

        return $html;
    }

    public static function getFSWatcherDescription(Phrases $phrases)
    {
        return $phrases->getDescription();
    }

    public static function getFSWatcherSnapshotsPeriodDescription(Phrases $phrases)
    {
        return $phrases->getSnapshotsPeriodDescription();
    }

    public static function getExtendedTabDescription(Phrases $phrases)
    {
        return $phrases->getExtendedTabDescription();
    }

    protected static function renderSelectorOptions($dates)
    {
        if (Controller::$debug) {
            Logger::log($dates);
        }

        $html = '';
        foreach ($dates as $date) {
            $formated_date = date('Y-m-d H:i:s', $date);
            $html .= '<option value="' . $date . '">' . $formated_date . '</option>';
        }

        return $html;
    }

    protected static function manualSnapshotButton(Phrases $phrases)
    {
        $html = '<div>';
        $html .= '<button class="spbc-icon-download" id="fswatcher__create_snapshot">' . $phrases->getCreateSnapshotButtonText() . '</button>';
        $html .= '<img style="display: none; margin-left: 10px; margin-top: 1px; width: 16px;" id="fsw_preloader_create" src="../../wp-content/plugins/security-malware-firewall/images/preloader2.gif"';
        $html .= '</div>';

        return $html;
    }

    protected static function renderTableTemplate(Phrases $phrases)
    {
        $html = '<div class="ui-accordion" id="spbc--fs-watcher-table-div">';
        $html .= '<p class="spbc_short_text_field" id="spbc--fs-watcher-table-handling-selects-info" style="display: none"></p>';
        $html .= '<table class="wp-list-table widefat fixed striped">';

        $html .= '<thead>';
        $html .=    '<tr>';
        $html .=        '<th>';
        $html .=        $phrases->getTableHeadPath();
        $html .=        '</th>';
        $html .=        '<th>';
        $html .=        $phrases->getTableHeadEvent();
        $html .=        '</th>';
        $html .=        '<th>';
        $html .=        $phrases->getTableHeadChangeOn();
        $html .=        '</th>';
        $html .=    '</tr>';
        $html .= '</thead>';

        $html .= '<tbody id="spbc-table-fs_watcher-comparison">';
        $html .=    '<tr id="spbc-tr-default-comparison-result">';
        $html .=        '<td colspan="3">';
        $html .=        $phrases->getTableNoLogs();
        $html .=        '</td>';
        $html .=    '</tr>';
        $html .= '</tbody>';

        $html .= '</table>';
        $html .= '</div>';

        return $html;
    }

    private static function snapshotsAreReady($dates)
    {
        return is_array($dates) && count($dates) > 1;
    }
}
