<?php

namespace CleantalkSP\SpbctWP\FSWatcher\Scan;

use CleantalkSP\SpbctWP\FSWatcher\Controller;
use CleantalkSP\SpbctWP\FSWatcher\Logger;
use CleantalkSP\SpbctWP\FSWatcher\Dto\FSWatcherParams;

class Scan
{
    /**
     * @var FSWatcherParams
     */
    private static $params;

    public static function run(FSWatcherParams $params)
    {
        self::$params = $params;
        $storage = Controller::$storage;
        $journal = $storage::makeProcessingJournal();
        if (Controller::$debug) {
            Logger::log('create processing journal ' . $journal);
        }

        self::scan();
    }

    protected static function scan()
    {
        $iterator = new \RecursiveIteratorIterator(
            new \RecursiveDirectoryIterator(self::$params->dir_to_watch, \RecursiveDirectoryIterator::SKIP_DOTS),
            \RecursiveIteratorIterator::SELF_FIRST,
            \RecursiveIteratorIterator::CATCH_GET_CHILD
        );
        $storage = Controller::$storage;
        $storage::writeJournal($iterator, self::$params->extensions_to_watch, self::$params->exclude_dirs);
    }
}
