<?php

namespace CleantalkSP\SpbctWP\AdminBannersModule\AdminBanners;

use CleantalkSP\SpbctWP\AdminBannersModule\AdminBannersHandler;

class AdminBannerFileEditorSettings extends AdminBannerAbstract
{
    const NAME = 'file_editor_settings';

    /**
     * @param AdminBannersHandler $banners_handler
     *
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function __construct(AdminBannersHandler $banners_handler)
    {
        $this->banner_id = $this->prefix . self::NAME . '_' . $banners_handler->getUserId();
    }

    protected function needToShow()
    {
        global $spbc;
        $no_wpconfig_error = !defined('SPBC_WPCONFIG_ERROR') || !constant('SPBC_WPCONFIG_ERROR');
        return (
            isset($spbc->settings['misc_disable_file_editor']) &&
            $spbc->settings['misc_disable_file_editor'] == 2 &&
            $no_wpconfig_error &&
            is_admin() &&
            isset($_GET['page']) && $_GET['page'] === 'spbc' &&
            current_user_can('administrator') &&
            !$this->isDismissed()
        );
    }

    protected function display()
    {
        ?>
        <div class="notice spbc-notice notice-warning is-dismissible" id="<?php echo esc_attr($this->banner_id); ?>" style="padding-bottom: 1em;">
            <h3>
                <?php echo esc_html__("File Editor Disabled Automatically", 'security-malware-firewall'); ?>
                <span style="cursor: pointer;" title="<?php echo esc_attr__("File editing in WordPress can be abused by malware to inject or persist malicious code. Disabling it prevents attackers from altering core files through the admin panel.", 'security-malware-firewall'); ?>">
                    <span style="color:#2271b1;vertical-align:middle;font-size:1.1em;" aria-label="Why?">ℹ️</span>
                </span>
            </h3>
            <p>
                <?php echo esc_html__("To prevent Remote Code Execution (RCE), the built-in WordPress file editor has been automatically disabled after detecting a critical infection.", 'security-malware-firewall'); ?>
            </p>
            <p>
                <?php echo esc_html__("This protects your website from backdoors and malicious code modifications via /wp-admin/theme-editor.php.", 'security-malware-firewall'); ?>
            </p>
            <p style="color: #888; font-size: 0.95em; margin-top: 1em;">
                <?php echo esc_html__("The protection will be removed automatically when all critical issues are resolved — unless you’ve manually enabled the block.", 'security-malware-firewall'); ?>
            </p>
        </div>
        <?php
    }
}