<?php

use CleantalkSP\SpbctWP\AdjustToEnvironmentModule\AdjustToEnvironmentHandler;

// Prevent direct call
/** @psalm-suppress ParadoxicalCondition */
if ( ! defined('ABSPATH') ) {
    die('Not allowed!');
}

add_action('wp_ajax_spbc_react_access_key_check', 'spbc_react_access_key_check');
add_action('wp_ajax_spbc_react_secfw_update_init', 'spbc_react_secfw_update_init');
add_action('wp_ajax_spbc_react_settings_exclusions', 'spbc_react_settings_exclusions');
add_action('wp_ajax_spbc_react_run_ajusting_env', 'spbc_react_run_ajusting_env');
add_action('wp_ajax_spbc_react_signatures_update', 'spbc_react_signatures_update');
add_action('wp_ajax_spbc_react_run_vulnerability_check', 'spbc_react_run_vulnerability_check');

function spbc_react_access_key_check()
{
    global $spbc;

    spbc_check_ajax_referer('spbc_secret_nonce', 'security');
    //Clearing all errors
    $spbc->error_delete_all('and_save_data');

    $account_is_ok = false;

    // If key provided by super admin
    if ( $spbc->is_mainsite || $spbc->ms__work_mode != 2 ) {
        // Checking account status
        $account_is_ok = spbc_check_account_status($spbc->api_key);
    }

    /*$out = array(
        'success' => true,
        'reload'  => $spbc->data['key_changed'] || !empty($spbc->errors),
    );*/

    $spbc->data['key_changed'] = false;
    $spbc->save('data');

    $res = [
        'error' => false,
        'message' => 'Test message',
        'success' => $account_is_ok,
    ];

    wp_send_json($res);
}

function spbc_react_secfw_update_init()
{
    global $spbc;

    spbc_check_ajax_referer('spbc_secret_nonce', 'security');

    $result = spbc_send_logs($spbc->api_key);
    if ( empty($result['error']) ) {
        $spbc->data['logs_last_sent']         = current_time('timestamp');
        $spbc->data['last_sent_events_count'] = $result;
        $spbc->error_delete('send_logs');
    } else {
        $spbc->error_add('send_logs', $result);
    }

    // Sending FW logs
    $result = spbc_send_firewall_logs($spbc->api_key);
    if ( empty($result['error']) ) {
        $spbc->fw_stats['last_send']       = current_time('timestamp');
        $spbc->fw_stats['last_send_count'] = $result;
        $spbc->error_delete('send_firewall_logs');
    } else {
        $spbc->error_add('send_firewall_logs', $result);
    }

    // Get custom message for security firewall
    $result_service_get = spbct_perform_service_get();
    if ( ! empty($result_service_get['error']) ) {
        if ($result_service_get['error_no'] !== 403) {
            $spbc->error_add('service_customize', $result_service_get['error']);
        }
    }

    // Updating FW
    //Reset last call of update_sec_fw
    $spbc->remote_calls['update_security_firewall']['last_call'] = 0;
    $spbc->save('remote_calls', true, false);

    $result = spbc_security_firewall_update__init();

    if ( ! empty($result['error']) ) {
        $spbc->error_add('firewall_update', $result['error']);
    }

    $spbc->save('data');
    $spbc->save('fw_stats', true, false);

    $res = [
        'error' => false,
        'message' => 'Test message',
        'success' => true,
    ];

    wp_send_json($res);
}

function spbc_react_signatures_update()
{
    global $spbc;

    spbc_check_ajax_referer('spbc_secret_nonce', 'security');

    // If key provided by super admin
    if ( is_main_site() ) {
        // Updating signtaures
        $result = spbc_scanner__signatures_update();
        empty($result['error'])
            ? $spbc->error_delete('scanner_update_signatures', 'save')
            : $spbc->error_add('scanner_update_signatures', $result);
    }

    $res = [
        'error' => false,
        'message' => 'Test message',
        'success' => true,
    ];

    wp_send_json($res);
}

function spbc_react_settings_exclusions()
{
    global $spbc;

    spbc_check_ajax_referer('spbc_secret_nonce', 'security');

    // Update scan settings exclusions
    $result_update_exclusions = spbc_update_scan_settings_exclusions();

    \CleantalkSP\SpbctWP\Cron::updateTask('update_scan_settings_exclusions', 'spbc_update_scan_settings_exclusions', 86400);
    if ( ! empty($result_update_exclusions['error']) ) {
        $spbc->error_add('update_exclusions', $result_update_exclusions['error']);
    }


    $res = [
        'error' => false,
        'message' => 'Test message',
        'success' => true,
    ];

    wp_send_json($res);
}

function spbc_react_run_ajusting_env()
{
    spbc_check_ajax_referer('spbc_secret_nonce', 'security');

    // Try to adjust to environment
    $adjust = new AdjustToEnvironmentHandler();
    $adjust->handle();

    $res = [
        'error' => false,
        'message' => 'Test message',
        'success' => true,
    ];

    wp_send_json($res);
}

function spbc_react_run_vulnerability_check()
{
    spbc_check_ajax_referer('spbc_secret_nonce', 'security');

    // Set cron task calling right now
    \CleantalkSP\SpbctWP\Cron::updateTask('check_vulnerabilities', 'spbc_security_check_vulnerabilities', 86400, time());

    $res = [
        'error' => false,
        'message' => 'Test message',
        'success' => true,
    ];

    wp_send_json($res);
}
