<?php
// Prevent direct call
if ( ! defined('ABSPATH') ) {
    die('Not allowed!');
}

global $spbc; ?>

<?php if (isset($data['title'])) { ?>
    <span class="spbc_settings-field_title spbc_settings-field_title--<?php echo $data['type']; ?>"><?php echo $data['title']; ?></span>
<?php } ?>

<?php if (isset($data['long_description'])) { ?>
    <i setting="<?php echo $data['name']; ?>" class="spbc_long_description__show spbc-icon-help-circled"></i>
<?php } ?>

<?php if (isset($data['description']) && function_exists($data['description'])) {
    call_user_func($data['description']);
} elseif (isset($data['description']) && ! function_exists($data['description'])) { ?>
    <div style="margin-bottom: 10px" class="spbc_settings_description"><?php echo $data['description']; ?></div>
<?php } ?>

<?php
if (!empty($data['disabled'])) {
    $text = !empty($data['disabled_text'])
        ? $data['ms_disabled_text']
        : esc_html__('This setting is disabled by administrator.', 'security-malware-firewall');
    echo '<div class="notice notice-info" style="margin:10px 0;">' . $text . '</div>';
    return;
}

foreach ($data['options'] as $option) {
    echo '<span class="spbc_radio_option">'
         . '<label>'
         . '<input'
         . ' type="radio"'
         . ' class="spbc_setting_' . $data['type'] . '"'
         . ' name="spbc_settings[' . $data['name'] . ']"'
         . ' value="' . $option['val'] . '"'
         . ($data['parent'] && ! $spbc->settings[ $data['parent'] ] ? ' disabled="disabled"' : '')
         . (! $data['children'] ? '' : ' children="' . implode(",", $data['children']) . '"')
         . (! $data['children'] ? '' : ' onchange="spbcSettingsDependencies(\'' . implode(",", $data['children']) . '\')"')
         . (! $data['children_by_ids'] ? '' : ' onchange="spbcSettingsDependenciesbyId([\'' . implode("','", $data['children_by_ids']) . '\'])"')
         . ($data['value'] == $option['val'] ? ' checked' : '') . ' />'
         . ' ' . $option['label']
         . '</label>'
         . '</span>';
    echo '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
}

?>
