<?php
 class HTTP_Request2_Exception extends PEAR_Exception { const INVALID_ARGUMENT = 1; const MISSING_VALUE = 2; const MISCONFIGURATION = 3; const READ_ERROR = 4; const MALFORMED_RESPONSE = 10; const DECODE_ERROR = 20; const TIMEOUT = 30; const TOO_MANY_REDIRECTS = 40; const NON_HTTP_REDIRECT = 50; private $_nativeCode; public function __construct($message = null, $code = null, $nativeCode = null) { parent::__construct($message, $code); $this->_nativeCode = $nativeCode; } public function getNativeCode() { return $this->_nativeCode; } } class HTTP_Request2_NotImplementedException extends HTTP_Request2_Exception {} class HTTP_Request2_LogicException extends HTTP_Request2_Exception {} class HTTP_Request2_ConnectionException extends HTTP_Request2_Exception {} class HTTP_Request2_MessageException extends HTTP_Request2_Exception {} class HTTP_Request2_Adapter_Socket extends HTTP_Request2_Adapter { const REGEXP_TOKEN = '[^\x00-\x1f\x7f-\xff()<>@,;:\\\\"/\[\]?={}\s]+'; const REGEXP_QUOTED_STRING = '"(?:\\\\.|[^\\\\"])*"'; protected static $sockets = array(); protected static $challenges = array(); protected $socket; protected $serverChallenge; protected $proxyChallenge; protected $deadline = null; protected $chunkLength = 0; protected $redirectCountdown = null; public function sendRequest(HTTP_Request2 $request) { $this->request = $request; if ($timeout = $request->getConfig('timeout')) { $this->deadline = time() + $timeout; } else { $this->deadline = null; } try { $keepAlive = $this->connect(); $headers = $this->prepareHeaders(); if (false === @fwrite($this->socket, $headers, strlen($headers))) { throw new HTTP_Request2_MessageException('Error writing request'); } $this->request->setLastEvent('sentHeaders', $headers); $this->writeBody(); if ($this->deadline && time() > $this->deadline) { throw new HTTP_Request2_MessageException( 'Request timed out after ' . $request->getConfig('timeout') . ' second(s)', HTTP_Request2_Exception::TIMEOUT ); } $response = $this->readResponse(); if ($jar = $request->getCookieJar()) { $jar->addCookiesFromResponse($response, $request->getUrl()); } if (!$this->canKeepAlive($keepAlive, $response)) { $this->disconnect(); } if ($this->shouldUseProxyDigestAuth($response)) { return $this->sendRequest($request); } if ($this->shouldUseServerDigestAuth($response)) { return $this->sendRequest($request); } if ($authInfo = $response->getHeader('authentication-info')) { $this->updateChallenge($this->serverChallenge, $authInfo); } if ($proxyInfo = $response->getHeader('proxy-authentication-info')) { $this->updateChallenge($this->proxyChallenge, $proxyInfo); } } catch (Exception $e) { $this->disconnect(); } unset($this->request, $this->requestBody); if (!empty($e)) { $this->redirectCountdown = null; throw $e; } if (!$request->getConfig('follow_redirects') || !$response->isRedirect()) { $this->redirectCountdown = null; return $response; } else { return $this->handleRedirect($request, $response); } } protected function connect() { $secure = 0 == strcasecmp($this->request->getUrl()->getScheme(), 'https'); $tunnel = HTTP_Request2::METHOD_CONNECT == $this->request->getMethod(); $headers = $this->request->getHeaders(); $reqHost = $this->request->getUrl()->getHost(); if (!($reqPort = $this->request->getUrl()->getPort())) { $reqPort = $secure? 443: 80; } if ($host = $this->request->getConfig('proxy_host')) { if (!($port = $this->request->getConfig('proxy_port'))) { throw new HTTP_Request2_LogicException( 'Proxy port not provided', HTTP_Request2_Exception::MISSING_VALUE ); } $proxy = true; } else { $host = $reqHost; $port = $reqPort; $proxy = false; } if ($tunnel && !$proxy) { throw new HTTP_Request2_LogicException( "Trying to perform CONNECT request without proxy", HTTP_Request2_Exception::MISSING_VALUE ); } if ($secure && !in_array('ssl', stream_get_transports())) { throw new HTTP_Request2_LogicException( 'Need OpenSSL support for https:// requests', HTTP_Request2_Exception::MISCONFIGURATION ); } if ($proxy && !$secure && !empty($headers['connection']) && 'Keep-Alive' == $headers['connection'] ) { $this->request->setHeader('connection'); } $keepAlive = ('1.1' == $this->request->getConfig('protocol_version') && empty($headers['connection'])) || (!empty($headers['connection']) && 'Keep-Alive' == $headers['connection']); $host = ((!$secure || $proxy)? 'tcp://': 'ssl://') . $host; $options = array(); if ($secure || $tunnel) { foreach ($this->request->getConfig() as $name => $value) { if ('ssl_' == substr($name, 0, 4) && null !== $value) { if ('ssl_verify_host' == $name) { if ($value) { $options['CN_match'] = $reqHost; } } else { $options[substr($name, 4)] = $value; } } } ksort($options); } $remote = $host . ':' . $port; $socketKey = $remote . (($secure && $proxy)? "->{$reqHost}:{$reqPort}": '') . (empty($options)? '': ':' . serialize($options)); unset($this->socket); if ($keepAlive && !empty(self::$sockets[$socketKey]) && !feof(self::$sockets[$socketKey]) ) { $this->socket =& self::$sockets[$socketKey]; } elseif ($secure && $proxy && !$tunnel) { $this->establishTunnel(); $this->request->setLastEvent( 'connect', "ssl://{$reqHost}:{$reqPort} via {$host}:{$port}" ); self::$sockets[$socketKey] =& $this->socket; } else { $context = stream_context_create(); foreach ($options as $name => $value) { if (!stream_context_set_option($context, 'ssl', $name, $value)) { throw new HTTP_Request2_LogicException( "Error setting SSL context option '{$name}'" ); } } $track = @ini_set('track_errors', 1); $this->socket = @stream_socket_client( $remote, $errno, $errstr, $this->request->getConfig('connect_timeout'), STREAM_CLIENT_CONNECT, $context ); if (!$this->socket) { $e = new HTTP_Request2_ConnectionException( "Unable to connect to {$remote}. Error: " . (empty($errstr)? $php_errormsg: $errstr), 0, $errno ); } @ini_set('track_errors', $track); if (isset($e)) { throw $e; } $this->request->setLastEvent('connect', $remote); self::$sockets[$socketKey] =& $this->socket; } return $keepAlive; } protected function establishTunnel() { $donor = new self; $connect = new HTTP_Request2( $this->request->getUrl(), HTTP_Request2::METHOD_CONNECT, array_merge($this->request->getConfig(), array('adapter' => $donor)) ); $response = $connect->send(); if (200 > $response->getStatus() || 300 <= $response->getStatus()) { throw new HTTP_Request2_ConnectionException( 'Failed to connect via HTTPS proxy. Proxy response: ' . $response->getStatus() . ' ' . $response->getReasonPhrase() ); } $this->socket = $donor->socket; $modes = array( STREAM_CRYPTO_METHOD_TLS_CLIENT, STREAM_CRYPTO_METHOD_SSLv3_CLIENT, STREAM_CRYPTO_METHOD_SSLv23_CLIENT, STREAM_CRYPTO_METHOD_SSLv2_CLIENT ); foreach ($modes as $mode) { if (stream_socket_enable_crypto($this->socket, true, $mode)) { return; } } throw new HTTP_Request2_ConnectionException( 'Failed to enable secure connection when connecting through proxy' ); } protected function canKeepAlive($requestKeepAlive, HTTP_Request2_Response $response) { if (HTTP_Request2::METHOD_CONNECT == $this->request->getMethod() && 200 <= $response->getStatus() && 300 > $response->getStatus() ) { return true; } $lengthKnown = 'chunked' == strtolower($response->getHeader('transfer-encoding')) || null !== $response->getHeader('content-length') || HTTP_Request2::METHOD_HEAD == $this->request->getMethod() || in_array($response->getStatus(), array(204, 304)); $persistent = 'keep-alive' == strtolower($response->getHeader('connection')) || (null === $response->getHeader('connection') && '1.1' == $response->getVersion()); return $requestKeepAlive && $lengthKnown && $persistent; } protected function disconnect() { if (is_resource($this->socket)) { fclose($this->socket); $this->socket = null; $this->request->setLastEvent('disconnect'); } } protected function handleRedirect(HTTP_Request2 $request, HTTP_Request2_Response $response) { if (is_null($this->redirectCountdown)) { $this->redirectCountdown = $request->getConfig('max_redirects'); } if (0 == $this->redirectCountdown) { $this->redirectCountdown = null; throw new HTTP_Request2_MessageException ( 'Maximum (' . $request->getConfig('max_redirects') . ') redirects followed', HTTP_Request2_Exception::TOO_MANY_REDIRECTS ); } $redirectUrl = new Net_URL2( $response->getHeader('location'), array(Net_URL2::OPTION_USE_BRACKETS => $request->getConfig('use_brackets')) ); if ($redirectUrl->isAbsolute() && !in_array($redirectUrl->getScheme(), array('http', 'https')) ) { $this->redirectCountdown = null; throw new HTTP_Request2_MessageException( 'Refusing to redirect to a non-HTTP URL ' . $redirectUrl->__toString(), HTTP_Request2_Exception::NON_HTTP_REDIRECT ); } if (!$redirectUrl->isAbsolute()) { $redirectUrl = $request->getUrl()->resolve($redirectUrl); } $redirect = clone $request; $redirect->setUrl($redirectUrl); if (303 == $response->getStatus() || (!$request->getConfig('strict_redirects') && in_array($response->getStatus(), array(301, 302))) ) { $redirect->setMethod(HTTP_Request2::METHOD_GET); $redirect->setBody(''); } if (0 < $this->redirectCountdown) { $this->redirectCountdown--; } return $this->sendRequest($redirect); } protected function shouldUseServerDigestAuth(HTTP_Request2_Response $response) { if (401 != $response->getStatus() || !$this->request->getAuth()) { return false; } if (!$challenge = $this->parseDigestChallenge($response->getHeader('www-authenticate'))) { return false; } $url = $this->request->getUrl(); $scheme = $url->getScheme(); $host = $scheme . '://' . $url->getHost(); if ($port = $url->getPort()) { if ((0 == strcasecmp($scheme, 'http') && 80 != $port) || (0 == strcasecmp($scheme, 'https') && 443 != $port) ) { $host .= ':' . $port; } } if (!empty($challenge['domain'])) { $prefixes = array(); foreach (preg_split('/\\s+/', $challenge['domain']) as $prefix) { if ('/' == substr($prefix, 0, 1)) { $prefixes[] = $host . $prefix; } } } if (empty($prefixes)) { $prefixes = array($host . '/'); } $ret = true; foreach ($prefixes as $prefix) { if (!empty(self::$challenges[$prefix]) && (empty($challenge['stale']) || strcasecmp('true', $challenge['stale'])) ) { $ret = false; } self::$challenges[$prefix] =& $challenge; } return $ret; } protected function shouldUseProxyDigestAuth(HTTP_Request2_Response $response) { if (407 != $response->getStatus() || !$this->request->getConfig('proxy_user')) { return false; } if (!($challenge = $this->parseDigestChallenge($response->getHeader('proxy-authenticate')))) { return false; } $key = 'proxy://' . $this->request->getConfig('proxy_host') . ':' . $this->request->getConfig('proxy_port'); if (!empty(self::$challenges[$key]) && (empty($challenge['stale']) || strcasecmp('true', $challenge['stale'])) ) { $ret = false; } else { $ret = true; } self::$challenges[$key] = $challenge; return $ret; } protected function parseDigestChallenge($headerValue) { $authParam = '(' . self::REGEXP_TOKEN . ')\\s*=\\s*(' . self::REGEXP_TOKEN . '|' . self::REGEXP_QUOTED_STRING . ')'; $challenge = "!(?<=^|\\s|,)Digest ({$authParam}\\s*(,\\s*|$))+!"; if (!preg_match($challenge, $headerValue, $matches)) { return false; } preg_match_all('!' . $authParam . '!', $matches[0], $params); $paramsAry = array(); $knownParams = array('realm', 'domain', 'nonce', 'opaque', 'stale', 'algorithm', 'qop'); for ($i = 0; $i < count($params[0]); $i++) { if (in_array($params[1][$i], $knownParams)) { if ('"' == substr($params[2][$i], 0, 1)) { $paramsAry[$params[1][$i]] = substr($params[2][$i], 1, -1); } else { $paramsAry[$params[1][$i]] = $params[2][$i]; } } } if (!empty($paramsAry['qop']) && !in_array('auth', array_map('trim', explode(',', $paramsAry['qop']))) ) { throw new HTTP_Request2_NotImplementedException( "Only 'auth' qop is currently supported in digest authentication, " . "server requested '{$paramsAry['qop']}'" ); } if (!empty($paramsAry['algorithm']) && 'MD5' != $paramsAry['algorithm']) { throw new HTTP_Request2_NotImplementedException( "Only 'MD5' algorithm is currently supported in digest authentication, " . "server requested '{$paramsAry['algorithm']}'" ); } return $paramsAry; } protected function updateChallenge(&$challenge, $headerValue) { $authParam = '!(' . self::REGEXP_TOKEN . ')\\s*=\\s*(' . self::REGEXP_TOKEN . '|' . self::REGEXP_QUOTED_STRING . ')!'; $paramsAry = array(); preg_match_all($authParam, $headerValue, $params); for ($i = 0; $i < count($params[0]); $i++) { if ('"' == substr($params[2][$i], 0, 1)) { $paramsAry[$params[1][$i]] = substr($params[2][$i], 1, -1); } else { $paramsAry[$params[1][$i]] = $params[2][$i]; } } if (!empty($paramsAry['nextnonce'])) { $challenge['nonce'] = $paramsAry['nextnonce']; $challenge['nc'] = 1; } } protected function createDigestResponse($user, $password, $url, &$challenge) { if (false !== ($q = strpos($url, '?')) && $this->request->getConfig('digest_compat_ie') ) { $url = substr($url, 0, $q); } $a1 = md5($user . ':' . $challenge['realm'] . ':' . $password); $a2 = md5($this->request->getMethod() . ':' . $url); if (empty($challenge['qop'])) { $digest = md5($a1 . ':' . $challenge['nonce'] . ':' . $a2); } else { $challenge['cnonce'] = 'Req2.' . rand(); if (empty($challenge['nc'])) { $challenge['nc'] = 1; } $nc = sprintf('%08x', $challenge['nc']++); $digest = md5($a1 . ':' . $challenge['nonce'] . ':' . $nc . ':' . $challenge['cnonce'] . ':auth:' . $a2); } return 'Digest username="' . str_replace(array('\\', '"'), array('\\\\', '\\"'), $user) . '", ' . 'realm="' . $challenge['realm'] . '", ' . 'nonce="' . $challenge['nonce'] . '", ' . 'uri="' . $url . '", ' . 'response="' . $digest . '"' . (!empty($challenge['opaque'])? ', opaque="' . $challenge['opaque'] . '"': '') . (!empty($challenge['qop'])? ', qop="auth", nc=' . $nc . ', cnonce="' . $challenge['cnonce'] . '"': ''); } protected function addAuthorizationHeader(&$headers, $requestHost, $requestUrl) { if (!($auth = $this->request->getAuth())) { return; } switch ($auth['scheme']) { case HTTP_Request2::AUTH_BASIC: $headers['authorization'] = 'Basic ' . base64_encode($auth['user'] . ':' . $auth['password']); break; case HTTP_Request2::AUTH_DIGEST: unset($this->serverChallenge); $fullUrl = ('/' == $requestUrl[0])? $this->request->getUrl()->getScheme() . '://' . $requestHost . $requestUrl: $requestUrl; foreach (array_keys(self::$challenges) as $key) { if ($key == substr($fullUrl, 0, strlen($key))) { $headers['authorization'] = $this->createDigestResponse( $auth['user'], $auth['password'], $requestUrl, self::$challenges[$key] ); $this->serverChallenge =& self::$challenges[$key]; break; } } break; default: throw new HTTP_Request2_NotImplementedException( "Unknown HTTP authentication scheme '{$auth['scheme']}'" ); } } protected function addProxyAuthorizationHeader(&$headers, $requestUrl) { if (!$this->request->getConfig('proxy_host') || !($user = $this->request->getConfig('proxy_user')) || (0 == strcasecmp('https', $this->request->getUrl()->getScheme()) && HTTP_Request2::METHOD_CONNECT != $this->request->getMethod()) ) { return; } $password = $this->request->getConfig('proxy_password'); switch ($this->request->getConfig('proxy_auth_scheme')) { case HTTP_Request2::AUTH_BASIC: $headers['proxy-authorization'] = 'Basic ' . base64_encode($user . ':' . $password); break; case HTTP_Request2::AUTH_DIGEST: unset($this->proxyChallenge); $proxyUrl = 'proxy://' . $this->request->getConfig('proxy_host') . ':' . $this->request->getConfig('proxy_port'); if (!empty(self::$challenges[$proxyUrl])) { $headers['proxy-authorization'] = $this->createDigestResponse( $user, $password, $requestUrl, self::$challenges[$proxyUrl] ); $this->proxyChallenge =& self::$challenges[$proxyUrl]; } break; default: throw new HTTP_Request2_NotImplementedException( "Unknown HTTP authentication scheme '" . $this->request->getConfig('proxy_auth_scheme') . "'" ); } } protected function prepareHeaders() { $headers = $this->request->getHeaders(); $url = $this->request->getUrl(); $connect = HTTP_Request2::METHOD_CONNECT == $this->request->getMethod(); $host = $url->getHost(); $defaultPort = 0 == strcasecmp($url->getScheme(), 'https')? 443: 80; if (($port = $url->getPort()) && $port != $defaultPort || $connect) { $host .= ':' . (empty($port)? $defaultPort: $port); } if (!isset($headers['host'])) { $headers['host'] = $host; } if ($connect) { $requestUrl = $host; } else { if (!$this->request->getConfig('proxy_host') || 0 == strcasecmp($url->getScheme(), 'https') ) { $requestUrl = ''; } else { $requestUrl = $url->getScheme() . '://' . $host; } $path = $url->getPath(); $query = $url->getQuery(); $requestUrl .= (empty($path)? '/': $path) . (empty($query)? '': '?' . $query); } if ('1.1' == $this->request->getConfig('protocol_version') && extension_loaded('zlib') && !isset($headers['accept-encoding']) ) { $headers['accept-encoding'] = 'gzip, deflate'; } if (($jar = $this->request->getCookieJar()) && ($cookies = $jar->getMatching($this->request->getUrl(), true)) ) { $headers['cookie'] = (empty($headers['cookie'])? '': $headers['cookie'] . '; ') . $cookies; } $this->addAuthorizationHeader($headers, $host, $requestUrl); $this->addProxyAuthorizationHeader($headers, $requestUrl); $this->calculateRequestLength($headers); $headersStr = $this->request->getMethod() . ' ' . $requestUrl . ' HTTP/' . $this->request->getConfig('protocol_version') . "\r\n"; foreach ($headers as $name => $value) { $canonicalName = implode('-', array_map('ucfirst', explode('-', $name))); $headersStr .= $canonicalName . ': ' . $value . "\r\n"; } return $headersStr . "\r\n"; } protected function writeBody() { if (in_array($this->request->getMethod(), self::$bodyDisallowed) || 0 == $this->contentLength ) { return; } $position = 0; $bufferSize = $this->request->getConfig('buffer_size'); while ($position < $this->contentLength) { if (is_string($this->requestBody)) { $str = substr($this->requestBody, $position, $bufferSize); } elseif (is_resource($this->requestBody)) { $str = fread($this->requestBody, $bufferSize); } else { $str = $this->requestBody->read($bufferSize); } if (false === @fwrite($this->socket, $str, strlen($str))) { throw new HTTP_Request2_MessageException('Error writing request'); } $this->request->setLastEvent('sentBodyPart', strlen($str)); $position += strlen($str); } $this->request->setLastEvent('sentBody', $this->contentLength); } protected function readResponse() { $bufferSize = $this->request->getConfig('buffer_size'); do { $response = new HTTP_Request2_Response( $this->readLine($bufferSize), true, $this->request->getUrl() ); do { $headerLine = $this->readLine($bufferSize); $response->parseHeaderLine($headerLine); } while ('' != $headerLine); } while (in_array($response->getStatus(), array(100, 101))); $this->request->setLastEvent('receivedHeaders', $response); if (HTTP_Request2::METHOD_HEAD == $this->request->getMethod() || (HTTP_Request2::METHOD_CONNECT == $this->request->getMethod() && 200 <= $response->getStatus() && 300 > $response->getStatus()) || in_array($response->getStatus(), array(204, 304)) ) { return $response; } $chunked = 'chunked' == $response->getHeader('transfer-encoding'); $length = $response->getHeader('content-length'); $hasBody = false; if ($chunked || null === $length || 0 < intval($length)) { $toRead = ($chunked || null === $length)? null: $length; $this->chunkLength = 0; while (!feof($this->socket) && (is_null($toRead) || 0 < $toRead)) { if ($chunked) { $data = $this->readChunked($bufferSize); } elseif (is_null($toRead)) { $data = $this->fread($bufferSize); } else { $data = $this->fread(min($toRead, $bufferSize)); $toRead -= strlen($data); } if ('' == $data && (!$this->chunkLength || feof($this->socket))) { break; } $hasBody = true; if ($this->request->getConfig('store_body')) { $response->appendBody($data); } if (!in_array($response->getHeader('content-encoding'), array('identity', null))) { $this->request->setLastEvent('receivedEncodedBodyPart', $data); } else { $this->request->setLastEvent('receivedBodyPart', $data); } } } if ($hasBody) { $this->request->setLastEvent('receivedBody', $response); } return $response; } protected function readLine($bufferSize) { $line = ''; while (!feof($this->socket)) { if ($this->deadline) { stream_set_timeout($this->socket, max($this->deadline - time(), 1)); } $line .= @fgets($this->socket, $bufferSize); $info = stream_get_meta_data($this->socket); if ($info['timed_out'] || $this->deadline && time() > $this->deadline) { $reason = $this->deadline ? 'after ' . $this->request->getConfig('timeout') . ' second(s)' : 'due to default_socket_timeout php.ini setting'; throw new HTTP_Request2_MessageException( "Request timed out {$reason}", HTTP_Request2_Exception::TIMEOUT ); } if (substr($line, -1) == "\n") { return rtrim($line, "\r\n"); } } return $line; } protected function fread($length) { if ($this->deadline) { stream_set_timeout($this->socket, max($this->deadline - time(), 1)); } $data = fread($this->socket, $length); $info = stream_get_meta_data($this->socket); if ($info['timed_out'] || $this->deadline && time() > $this->deadline) { $reason = $this->deadline ? 'after ' . $this->request->getConfig('timeout') . ' second(s)' : 'due to default_socket_timeout php.ini setting'; throw new HTTP_Request2_MessageException( "Request timed out {$reason}", HTTP_Request2_Exception::TIMEOUT ); } return $data; } protected function readChunked($bufferSize) { if (0 == $this->chunkLength) { $line = $this->readLine($bufferSize); if (!preg_match('/^([0-9a-f]+)/i', $line, $matches)) { throw new HTTP_Request2_MessageException( "Cannot decode chunked response, invalid chunk length '{$line}'", HTTP_Request2_Exception::DECODE_ERROR ); } else { $this->chunkLength = hexdec($matches[1]); if (0 == $this->chunkLength) { $this->readLine($bufferSize); return ''; } } } $data = $this->fread(min($this->chunkLength, $bufferSize)); $this->chunkLength -= strlen($data); if (0 == $this->chunkLength) { $this->readLine($bufferSize); } return $data; } } class HTTP_Request2_Adapter_Curl extends HTTP_Request2_Adapter { protected static $headerMap = array( 'accept-encoding' => CURLOPT_ENCODING, 'cookie' => CURLOPT_COOKIE, 'referer' => CURLOPT_REFERER, 'user-agent' => CURLOPT_USERAGENT ); protected static $sslContextMap = array( 'ssl_verify_peer' => CURLOPT_SSL_VERIFYPEER, 'ssl_cafile' => CURLOPT_CAINFO, 'ssl_capath' => CURLOPT_CAPATH, 'ssl_local_cert' => CURLOPT_SSLCERT, 'ssl_passphrase' => CURLOPT_SSLCERTPASSWD ); protected static $errorMap = array( CURLE_UNSUPPORTED_PROTOCOL => array('HTTP_Request2_MessageException', HTTP_Request2_Exception::NON_HTTP_REDIRECT), CURLE_COULDNT_RESOLVE_PROXY => array('HTTP_Request2_ConnectionException'), CURLE_COULDNT_RESOLVE_HOST => array('HTTP_Request2_ConnectionException'), CURLE_COULDNT_CONNECT => array('HTTP_Request2_ConnectionException'), CURLE_WRITE_ERROR => array('HTTP_Request2_MessageException', HTTP_Request2_Exception::NON_HTTP_REDIRECT), CURLE_OPERATION_TIMEOUTED => array('HTTP_Request2_MessageException', HTTP_Request2_Exception::TIMEOUT), CURLE_HTTP_RANGE_ERROR => array('HTTP_Request2_MessageException'), CURLE_SSL_CONNECT_ERROR => array('HTTP_Request2_ConnectionException'), CURLE_LIBRARY_NOT_FOUND => array('HTTP_Request2_LogicException', HTTP_Request2_Exception::MISCONFIGURATION), CURLE_FUNCTION_NOT_FOUND => array('HTTP_Request2_LogicException', HTTP_Request2_Exception::MISCONFIGURATION), CURLE_ABORTED_BY_CALLBACK => array('HTTP_Request2_MessageException', HTTP_Request2_Exception::NON_HTTP_REDIRECT), CURLE_TOO_MANY_REDIRECTS => array('HTTP_Request2_MessageException', HTTP_Request2_Exception::TOO_MANY_REDIRECTS), CURLE_SSL_PEER_CERTIFICATE => array('HTTP_Request2_ConnectionException'), CURLE_GOT_NOTHING => array('HTTP_Request2_MessageException'), CURLE_SSL_ENGINE_NOTFOUND => array('HTTP_Request2_LogicException', HTTP_Request2_Exception::MISCONFIGURATION), CURLE_SSL_ENGINE_SETFAILED => array('HTTP_Request2_LogicException', HTTP_Request2_Exception::MISCONFIGURATION), CURLE_SEND_ERROR => array('HTTP_Request2_MessageException'), CURLE_RECV_ERROR => array('HTTP_Request2_MessageException'), CURLE_SSL_CERTPROBLEM => array('HTTP_Request2_LogicException', HTTP_Request2_Exception::INVALID_ARGUMENT), CURLE_SSL_CIPHER => array('HTTP_Request2_ConnectionException'), CURLE_SSL_CACERT => array('HTTP_Request2_ConnectionException'), CURLE_BAD_CONTENT_ENCODING => array('HTTP_Request2_MessageException'), ); protected $response; protected $eventSentHeaders = false; protected $eventReceivedHeaders = false; protected $position = 0; protected $lastInfo; protected static function wrapCurlError($ch) { $nativeCode = curl_errno($ch); $message = 'Curl error: ' . curl_error($ch); if (!isset(self::$errorMap[$nativeCode])) { return new HTTP_Request2_Exception($message, 0, $nativeCode); } else { $class = self::$errorMap[$nativeCode][0]; $code = empty(self::$errorMap[$nativeCode][1]) ? 0 : self::$errorMap[$nativeCode][1]; return new $class($message, $code, $nativeCode); } } public function sendRequest(HTTP_Request2 $request) { if (!extension_loaded('curl')) { throw new HTTP_Request2_LogicException( 'cURL extension not available', HTTP_Request2_Exception::MISCONFIGURATION ); } $this->request = $request; $this->response = null; $this->position = 0; $this->eventSentHeaders = false; $this->eventReceivedHeaders = false; try { if (false === curl_exec($ch = $this->createCurlHandle())) { $e = self::wrapCurlError($ch); } } catch (Exception $e) { } if (isset($ch)) { $this->lastInfo = curl_getinfo($ch); curl_close($ch); } $response = $this->response; unset($this->request, $this->requestBody, $this->response); if (!empty($e)) { throw $e; } if ($jar = $request->getCookieJar()) { $jar->addCookiesFromResponse($response, $request->getUrl()); } if (0 < $this->lastInfo['size_download']) { $request->setLastEvent('receivedBody', $response); } return $response; } public function getInfo() { return $this->lastInfo; } protected function createCurlHandle() { $ch = curl_init(); curl_setopt_array($ch, array( CURLOPT_HEADERFUNCTION => array($this, 'callbackWriteHeader'), CURLOPT_WRITEFUNCTION => array($this, 'callbackWriteBody'), CURLOPT_BUFFERSIZE => $this->request->getConfig('buffer_size'), CURLOPT_CONNECTTIMEOUT => $this->request->getConfig('connect_timeout'), CURLINFO_HEADER_OUT => true, CURLOPT_URL => $this->request->getUrl()->getUrl() )); if (!$this->request->getConfig('follow_redirects')) { curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false); } else { if (!@curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true)) { throw new HTTP_Request2_LogicException( 'Redirect support in curl is unavailable due to open_basedir or safe_mode setting', HTTP_Request2_Exception::MISCONFIGURATION ); } curl_setopt($ch, CURLOPT_MAXREDIRS, $this->request->getConfig('max_redirects')); if (defined('CURLOPT_REDIR_PROTOCOLS')) { curl_setopt($ch, CURLOPT_REDIR_PROTOCOLS, CURLPROTO_HTTP | CURLPROTO_HTTPS); } if ($this->request->getConfig('strict_redirects') && defined('CURLOPT_POSTREDIR')) { curl_setopt($ch, CURLOPT_POSTREDIR, 3); } } if ($timeout = $this->request->getConfig('timeout')) { curl_setopt($ch, CURLOPT_TIMEOUT, $timeout); } switch ($this->request->getConfig('protocol_version')) { case '1.0': curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_0); break; case '1.1': curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1); } switch ($this->request->getMethod()) { case HTTP_Request2::METHOD_GET: curl_setopt($ch, CURLOPT_HTTPGET, true); break; case HTTP_Request2::METHOD_POST: curl_setopt($ch, CURLOPT_POST, true); break; case HTTP_Request2::METHOD_HEAD: curl_setopt($ch, CURLOPT_NOBODY, true); break; case HTTP_Request2::METHOD_PUT: curl_setopt($ch, CURLOPT_UPLOAD, true); break; default: curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $this->request->getMethod()); } if ($host = $this->request->getConfig('proxy_host')) { if (!($port = $this->request->getConfig('proxy_port'))) { throw new HTTP_Request2_LogicException( 'Proxy port not provided', HTTP_Request2_Exception::MISSING_VALUE ); } curl_setopt($ch, CURLOPT_PROXY, $host . ':' . $port); if ($user = $this->request->getConfig('proxy_user')) { curl_setopt($ch, CURLOPT_PROXYUSERPWD, $user . ':' . $this->request->getConfig('proxy_password')); switch ($this->request->getConfig('proxy_auth_scheme')) { case HTTP_Request2::AUTH_BASIC: curl_setopt($ch, CURLOPT_PROXYAUTH, CURLAUTH_BASIC); break; case HTTP_Request2::AUTH_DIGEST: curl_setopt($ch, CURLOPT_PROXYAUTH, CURLAUTH_DIGEST); } } } if ($auth = $this->request->getAuth()) { curl_setopt($ch, CURLOPT_USERPWD, $auth['user'] . ':' . $auth['password']); switch ($auth['scheme']) { case HTTP_Request2::AUTH_BASIC: curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC); break; case HTTP_Request2::AUTH_DIGEST: curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_DIGEST); } } foreach ($this->request->getConfig() as $name => $value) { if ('ssl_verify_host' == $name && null !== $value) { curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, $value? 2: 0); } elseif (isset(self::$sslContextMap[$name]) && null !== $value) { curl_setopt($ch, self::$sslContextMap[$name], $value); } } $headers = $this->request->getHeaders(); if (!isset($headers['accept-encoding'])) { $headers['accept-encoding'] = ''; } if (($jar = $this->request->getCookieJar()) && ($cookies = $jar->getMatching($this->request->getUrl(), true)) ) { $headers['cookie'] = (empty($headers['cookie'])? '': $headers['cookie'] . '; ') . $cookies; } foreach (self::$headerMap as $name => $option) { if (isset($headers[$name])) { curl_setopt($ch, $option, $headers[$name]); unset($headers[$name]); } } $this->calculateRequestLength($headers); if (isset($headers['content-length'])) { $this->workaroundPhpBug47204($ch, $headers); } $headersFmt = array(); foreach ($headers as $name => $value) { $canonicalName = implode('-', array_map('ucfirst', explode('-', $name))); $headersFmt[] = $canonicalName . ': ' . $value; } curl_setopt($ch, CURLOPT_HTTPHEADER, $headersFmt); return $ch; } protected function workaroundPhpBug47204($ch, &$headers) { if (!$this->request->getConfig('follow_redirects') && (!($auth = $this->request->getAuth()) || HTTP_Request2::AUTH_DIGEST != $auth['scheme']) ) { curl_setopt($ch, CURLOPT_READFUNCTION, array($this, 'callbackReadBody')); } else { if ($this->requestBody instanceof HTTP_Request2_MultipartBody) { $this->requestBody = $this->requestBody->__toString(); } elseif (is_resource($this->requestBody)) { $fp = $this->requestBody; $this->requestBody = ''; while (!feof($fp)) { $this->requestBody .= fread($fp, 16384); } } unset($headers['content-length']); curl_setopt($ch, CURLOPT_POSTFIELDS, $this->requestBody); } } protected function callbackReadBody($ch, $fd, $length) { if (!$this->eventSentHeaders) { $this->request->setLastEvent( 'sentHeaders', curl_getinfo($ch, CURLINFO_HEADER_OUT) ); $this->eventSentHeaders = true; } if (in_array($this->request->getMethod(), self::$bodyDisallowed) || 0 == $this->contentLength || $this->position >= $this->contentLength ) { return ''; } if (is_string($this->requestBody)) { $string = substr($this->requestBody, $this->position, $length); } elseif (is_resource($this->requestBody)) { $string = fread($this->requestBody, $length); } else { $string = $this->requestBody->read($length); } $this->request->setLastEvent('sentBodyPart', strlen($string)); $this->position += strlen($string); return $string; } protected function callbackWriteHeader($ch, $string) { if ($this->eventReceivedHeaders || !$this->eventSentHeaders) { if (!$this->eventSentHeaders || $this->response->getStatus() >= 200 ) { $this->request->setLastEvent( 'sentHeaders', curl_getinfo($ch, CURLINFO_HEADER_OUT) ); } $upload = curl_getinfo($ch, CURLINFO_SIZE_UPLOAD); if ($upload > $this->position) { $this->request->setLastEvent( 'sentBodyPart', $upload - $this->position ); $this->position = $upload; } if ($upload && (!$this->eventSentHeaders || $this->response->getStatus() >= 200) ) { $this->request->setLastEvent('sentBody', $upload); } $this->eventSentHeaders = true; if ($this->eventReceivedHeaders) { $this->eventReceivedHeaders = false; $this->response = null; } } if (empty($this->response)) { $this->response = new HTTP_Request2_Response( $string, false, curl_getinfo($ch, CURLINFO_EFFECTIVE_URL) ); } else { $this->response->parseHeaderLine($string); if ('' == trim($string)) { if (200 <= $this->response->getStatus()) { $this->request->setLastEvent('receivedHeaders', $this->response); } if ($this->request->getConfig('follow_redirects') && $this->response->isRedirect()) { $redirectUrl = new Net_URL2($this->response->getHeader('location')); if (!defined('CURLOPT_REDIR_PROTOCOLS') && $redirectUrl->isAbsolute() && !in_array($redirectUrl->getScheme(), array('http', 'https')) ) { return -1; } if ($jar = $this->request->getCookieJar()) { $jar->addCookiesFromResponse($this->response, $this->request->getUrl()); if (!$redirectUrl->isAbsolute()) { $redirectUrl = $this->request->getUrl()->resolve($redirectUrl); } if ($cookies = $jar->getMatching($redirectUrl, true)) { curl_setopt($ch, CURLOPT_COOKIE, $cookies); } } } $this->eventReceivedHeaders = true; } } return strlen($string); } protected function callbackWriteBody($ch, $string) { if (empty($this->response)) { throw new HTTP_Request2_MessageException( "Malformed response: {$string}", HTTP_Request2_Exception::MALFORMED_RESPONSE ); } if ($this->request->getConfig('store_body')) { $this->response->appendBody($string); } $this->request->setLastEvent('receivedBodyPart', $string); return strlen($string); } } class HTTP_Request2_Adapter_Mock extends HTTP_Request2_Adapter { protected $responses = array(); public function sendRequest(HTTP_Request2 $request) { if (count($this->responses) > 0) { $response = array_shift($this->responses); if ($response instanceof HTTP_Request2_Response) { return $response; } else { $class = get_class($response); $message = $response->getMessage(); $code = $response->getCode(); throw new $class($message, $code); } } else { return self::createResponseFromString("HTTP/1.1 400 Bad Request\r\n\r\n"); } } public function addResponse($response) { if (is_string($response)) { $response = self::createResponseFromString($response); } elseif (is_resource($response)) { $response = self::createResponseFromFile($response); } elseif (!$response instanceof HTTP_Request2_Response && !$response instanceof Exception ) { throw new HTTP_Request2_Exception('Parameter is not a valid response'); } $this->responses[] = $response; } public static function createResponseFromString($str) { $parts = preg_split('!(\r?\n){2}!m', $str, 2); $headerLines = explode("\n", $parts[0]); $response = new HTTP_Request2_Response(array_shift($headerLines)); foreach ($headerLines as $headerLine) { $response->parseHeaderLine($headerLine); } $response->parseHeaderLine(''); if (isset($parts[1])) { $response->appendBody($parts[1]); } return $response; } public static function createResponseFromFile($fp) { $response = new HTTP_Request2_Response(fgets($fp)); do { $headerLine = fgets($fp); $response->parseHeaderLine($headerLine); } while ('' != trim($headerLine)); while (!feof($fp)) { $response->appendBody(fread($fp, 8192)); } return $response; } } class HTTP_Request2_Response { protected $version; protected $code; protected $reasonPhrase; protected $effectiveUrl; protected $headers = array(); protected $cookies = array(); protected $lastHeader = null; protected $body = ''; protected $bodyEncoded; protected static $phrases = array( 100 => 'Continue', 101 => 'Switching Protocols', 200 => 'OK', 201 => 'Created', 202 => 'Accepted', 203 => 'Non-Authoritative Information', 204 => 'No Content', 205 => 'Reset Content', 206 => 'Partial Content', 300 => 'Multiple Choices', 301 => 'Moved Permanently', 302 => 'Found', 303 => 'See Other', 304 => 'Not Modified', 305 => 'Use Proxy', 307 => 'Temporary Redirect', 400 => 'Bad Request', 401 => 'Unauthorized', 402 => 'Payment Required', 403 => 'Forbidden', 404 => 'Not Found', 405 => 'Method Not Allowed', 406 => 'Not Acceptable', 407 => 'Proxy Authentication Required', 408 => 'Request Timeout', 409 => 'Conflict', 410 => 'Gone', 411 => 'Length Required', 412 => 'Precondition Failed', 413 => 'Request Entity Too Large', 414 => 'Request-URI Too Long', 415 => 'Unsupported Media Type', 416 => 'Requested Range Not Satisfiable', 417 => 'Expectation Failed', 500 => 'Internal Server Error', 501 => 'Not Implemented', 502 => 'Bad Gateway', 503 => 'Service Unavailable', 504 => 'Gateway Timeout', 505 => 'HTTP Version Not Supported', 509 => 'Bandwidth Limit Exceeded', ); public static function getDefaultReasonPhrase($code = null) { if (null === $code) { return self::$phrases; } else { return isset(self::$phrases[$code]) ? self::$phrases[$code] : null; } } public function __construct($statusLine, $bodyEncoded = true, $effectiveUrl = null) { if (!preg_match('!^HTTP/(\d\.\d) (\d{3})(?: (.+))?!', $statusLine, $m)) { throw new HTTP_Request2_MessageException( "Malformed response: {$statusLine}", HTTP_Request2_Exception::MALFORMED_RESPONSE ); } $this->version = $m[1]; $this->code = intval($m[2]); $this->reasonPhrase = !empty($m[3]) ? trim($m[3]) : self::getDefaultReasonPhrase($this->code); $this->bodyEncoded = (bool)$bodyEncoded; $this->effectiveUrl = (string)$effectiveUrl; } public function parseHeaderLine($headerLine) { $headerLine = trim($headerLine, "\r\n"); if ('' == $headerLine) { if (!empty($this->headers['set-cookie'])) { $cookies = is_array($this->headers['set-cookie'])? $this->headers['set-cookie']: array($this->headers['set-cookie']); foreach ($cookies as $cookieString) { $this->parseCookie($cookieString); } unset($this->headers['set-cookie']); } foreach (array_keys($this->headers) as $k) { if (is_array($this->headers[$k])) { $this->headers[$k] = implode(', ', $this->headers[$k]); } } } elseif (preg_match('!^([^\x00-\x1f\x7f-\xff()<>@,;:\\\\"/\[\]?={}\s]+):(.+)$!', $headerLine, $m)) { $name = strtolower($m[1]); $value = trim($m[2]); if (empty($this->headers[$name])) { $this->headers[$name] = $value; } else { if (!is_array($this->headers[$name])) { $this->headers[$name] = array($this->headers[$name]); } $this->headers[$name][] = $value; } $this->lastHeader = $name; } elseif (preg_match('!^\s+(.+)$!', $headerLine, $m) && $this->lastHeader) { if (!is_array($this->headers[$this->lastHeader])) { $this->headers[$this->lastHeader] .= ' ' . trim($m[1]); } else { $key = count($this->headers[$this->lastHeader]) - 1; $this->headers[$this->lastHeader][$key] .= ' ' . trim($m[1]); } } } protected function parseCookie($cookieString) { $cookie = array( 'expires' => null, 'domain' => null, 'path' => null, 'secure' => false ); if (!strpos($cookieString, ';')) { $pos = strpos($cookieString, '='); $cookie['name'] = trim(substr($cookieString, 0, $pos)); $cookie['value'] = trim(substr($cookieString, $pos + 1)); } else { $elements = explode(';', $cookieString); $pos = strpos($elements[0], '='); $cookie['name'] = trim(substr($elements[0], 0, $pos)); $cookie['value'] = trim(substr($elements[0], $pos + 1)); for ($i = 1; $i < count($elements); $i++) { if (false === strpos($elements[$i], '=')) { $elName = trim($elements[$i]); $elValue = null; } else { list ($elName, $elValue) = array_map('trim', explode('=', $elements[$i])); } $elName = strtolower($elName); if ('secure' == $elName) { $cookie['secure'] = true; } elseif ('expires' == $elName) { $cookie['expires'] = str_replace('"', '', $elValue); } elseif ('path' == $elName || 'domain' == $elName) { $cookie[$elName] = urldecode($elValue); } else { $cookie[$elName] = $elValue; } } } $this->cookies[] = $cookie; } public function appendBody($bodyChunk) { $this->body .= $bodyChunk; } public function getEffectiveUrl() { return $this->effectiveUrl; } public function getStatus() { return $this->code; } public function getReasonPhrase() { return $this->reasonPhrase; } public function isRedirect() { return in_array($this->code, array(300, 301, 302, 303, 307)) && isset($this->headers['location']); } public function getHeader($headerName = null) { if (null === $headerName) { return $this->headers; } else { $headerName = strtolower($headerName); return isset($this->headers[$headerName])? $this->headers[$headerName]: null; } } public function getCookies() { return $this->cookies; } public function getBody() { if (0 == strlen($this->body) || !$this->bodyEncoded || !in_array(strtolower($this->getHeader('content-encoding')), array('gzip', 'deflate')) ) { return $this->body; } else { if (extension_loaded('mbstring') && (2 & ini_get('mbstring.func_overload'))) { $oldEncoding = mb_internal_encoding(); mb_internal_encoding('iso-8859-1'); } try { switch (strtolower($this->getHeader('content-encoding'))) { case 'gzip': $decoded = self::decodeGzip($this->body); break; case 'deflate': $decoded = self::decodeDeflate($this->body); } } catch (Exception $e) { } if (!empty($oldEncoding)) { mb_internal_encoding($oldEncoding); } if (!empty($e)) { throw $e; } return $decoded; } } public function getVersion() { return $this->version; } public static function decodeGzip($data) { $length = strlen($data); if (18 > $length || strcmp(substr($data, 0, 2), "\x1f\x8b")) { return $data; } if (!function_exists('gzinflate')) { throw new HTTP_Request2_LogicException( 'Unable to decode body: gzip extension not available', HTTP_Request2_Exception::MISCONFIGURATION ); } $method = ord(substr($data, 2, 1)); if (8 != $method) { throw new HTTP_Request2_MessageException( 'Error parsing gzip header: unknown compression method', HTTP_Request2_Exception::DECODE_ERROR ); } $flags = ord(substr($data, 3, 1)); if ($flags & 224) { throw new HTTP_Request2_MessageException( 'Error parsing gzip header: reserved bits are set', HTTP_Request2_Exception::DECODE_ERROR ); } $headerLength = 10; if ($flags & 4) { if ($length - $headerLength - 2 < 8) { throw new HTTP_Request2_MessageException( 'Error parsing gzip header: data too short', HTTP_Request2_Exception::DECODE_ERROR ); } $extraLength = unpack('v', substr($data, 10, 2)); if ($length - $headerLength - 2 - $extraLength[1] < 8) { throw new HTTP_Request2_MessageException( 'Error parsing gzip header: data too short', HTTP_Request2_Exception::DECODE_ERROR ); } $headerLength += $extraLength[1] + 2; } if ($flags & 8) { if ($length - $headerLength - 1 < 8) { throw new HTTP_Request2_MessageException( 'Error parsing gzip header: data too short', HTTP_Request2_Exception::DECODE_ERROR ); } $filenameLength = strpos(substr($data, $headerLength), chr(0)); if (false === $filenameLength || $length - $headerLength - $filenameLength - 1 < 8) { throw new HTTP_Request2_MessageException( 'Error parsing gzip header: data too short', HTTP_Request2_Exception::DECODE_ERROR ); } $headerLength += $filenameLength + 1; } if ($flags & 16) { if ($length - $headerLength - 1 < 8) { throw new HTTP_Request2_MessageException( 'Error parsing gzip header: data too short', HTTP_Request2_Exception::DECODE_ERROR ); } $commentLength = strpos(substr($data, $headerLength), chr(0)); if (false === $commentLength || $length - $headerLength - $commentLength - 1 < 8) { throw new HTTP_Request2_MessageException( 'Error parsing gzip header: data too short', HTTP_Request2_Exception::DECODE_ERROR ); } $headerLength += $commentLength + 1; } if ($flags & 2) { if ($length - $headerLength - 2 < 8) { throw new HTTP_Request2_MessageException( 'Error parsing gzip header: data too short', HTTP_Request2_Exception::DECODE_ERROR ); } $crcReal = 0xffff & crc32(substr($data, 0, $headerLength)); $crcStored = unpack('v', substr($data, $headerLength, 2)); if ($crcReal != $crcStored[1]) { throw new HTTP_Request2_MessageException( 'Header CRC check failed', HTTP_Request2_Exception::DECODE_ERROR ); } $headerLength += 2; } $tmp = unpack('V2', substr($data, -8)); $dataCrc = $tmp[1]; $dataSize = $tmp[2]; $unpacked = gzinflate(substr($data, $headerLength, -8)); if (false === $unpacked) { throw new HTTP_Request2_MessageException( 'gzinflate() call failed', HTTP_Request2_Exception::DECODE_ERROR ); } elseif ($dataSize != strlen($unpacked)) { throw new HTTP_Request2_MessageException( 'Data size check failed', HTTP_Request2_Exception::DECODE_ERROR ); } elseif ((0xffffffff & $dataCrc) != (0xffffffff & crc32($unpacked))) { throw new HTTP_Request2_Exception( 'Data CRC check failed', HTTP_Request2_Exception::DECODE_ERROR ); } return $unpacked; } public static function decodeDeflate($data) { if (!function_exists('gzuncompress')) { throw new HTTP_Request2_LogicException( 'Unable to decode body: gzip extension not available', HTTP_Request2_Exception::MISCONFIGURATION ); } $header = unpack('n', substr($data, 0, 2)); return (0 == $header[1] % 31)? gzuncompress($data): gzinflate($data); } } class HTTP_Request2_Observer_Log implements SplObserver { protected $target = null; public $events = array( 'connect', 'sentHeaders', 'sentBody', 'receivedHeaders', 'receivedBody', 'disconnect', ); public function __construct($target = 'php://output', array $events = array()) { if (!empty($events)) { $this->events = $events; } if (is_resource($target) || $target instanceof Log) { $this->target = $target; } elseif (false === ($this->target = @fopen($target, 'ab'))) { throw new HTTP_Request2_Exception("Unable to open '{$target}'"); } } public function update(SplSubject $subject) { $event = $subject->getLastEvent(); if (!in_array($event['name'], $this->events)) { return; } switch ($event['name']) { case 'connect': $this->log('* Connected to ' . $event['data']); break; case 'sentHeaders': $headers = explode("\r\n", $event['data']); array_pop($headers); foreach ($headers as $header) { $this->log('> ' . $header); } break; case 'sentBody': $this->log('> ' . $event['data'] . ' byte(s) sent'); break; case 'receivedHeaders': $this->log(sprintf('< HTTP/%s %s %s', $event['data']->getVersion(), $event['data']->getStatus(), $event['data']->getReasonPhrase())); $headers = $event['data']->getHeader(); foreach ($headers as $key => $val) { $this->log('< ' . $key . ': ' . $val); } $this->log('< '); break; case 'receivedBody': $this->log($event['data']->getBody()); break; case 'disconnect': $this->log('* Disconnected'); break; } } protected function log($message) { if ($this->target instanceof Log) { $this->target->debug($message); } elseif (is_resource($this->target)) { fwrite($this->target, $message . "\r\n"); } } } abstract class HTTP_Request2_Adapter { protected static $bodyDisallowed = array('TRACE'); protected static $bodyRequired = array('POST', 'PUT'); protected $request; protected $requestBody; protected $contentLength; abstract public function sendRequest(HTTP_Request2 $request); protected function calculateRequestLength(&$headers) { $this->requestBody = $this->request->getBody(); if (is_string($this->requestBody)) { $this->contentLength = strlen($this->requestBody); } elseif (is_resource($this->requestBody)) { $stat = fstat($this->requestBody); $this->contentLength = $stat['size']; rewind($this->requestBody); } else { $this->contentLength = $this->requestBody->getLength(); $headers['content-type'] = 'multipart/form-data; boundary=' . $this->requestBody->getBoundary(); $this->requestBody->rewind(); } if (in_array($this->request->getMethod(), self::$bodyDisallowed) || 0 == $this->contentLength ) { if (in_array($this->request->getMethod(), self::$bodyRequired)) { $headers['content-length'] = 0; } else { unset($headers['content-length']); unset($headers['content-type']); } } else { if (empty($headers['content-type'])) { $headers['content-type'] = 'application/x-www-form-urlencoded'; } $headers['content-length'] = $this->contentLength; } } } class HTTP_Request2_CookieJar implements Serializable { protected $cookies = array(); protected $serializeSession = false; protected $useList = true; protected static $psl = array(); public function __construct($serializeSessionCookies = false, $usePublicSuffixList = true) { $this->serializeSessionCookies($serializeSessionCookies); $this->usePublicSuffixList($usePublicSuffixList); } protected function now() { $dt = new DateTime(); $dt->setTimezone(new DateTimeZone('UTC')); return $dt->format(DateTime::ISO8601); } protected function checkAndUpdateFields(array $cookie, Net_URL2 $setter = null) { if ($missing = array_diff(array('name', 'value'), array_keys($cookie))) { throw new HTTP_Request2_LogicException( "Cookie array should contain 'name' and 'value' fields", HTTP_Request2_Exception::MISSING_VALUE ); } if (preg_match(HTTP_Request2::REGEXP_INVALID_COOKIE, $cookie['name'])) { throw new HTTP_Request2_LogicException( "Invalid cookie name: '{$cookie['name']}'", HTTP_Request2_Exception::INVALID_ARGUMENT ); } if (preg_match(HTTP_Request2::REGEXP_INVALID_COOKIE, $cookie['value'])) { throw new HTTP_Request2_LogicException( "Invalid cookie value: '{$cookie['value']}'", HTTP_Request2_Exception::INVALID_ARGUMENT ); } $cookie += array('domain' => '', 'path' => '', 'expires' => null, 'secure' => false); if (!empty($cookie['expires']) && !preg_match('/^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\+0000$/', $cookie['expires']) ) { try { $dt = new DateTime($cookie['expires']); $dt->setTimezone(new DateTimeZone('UTC')); $cookie['expires'] = $dt->format(DateTime::ISO8601); } catch (Exception $e) { throw new HTTP_Request2_LogicException($e->getMessage()); } } if (empty($cookie['domain']) || empty($cookie['path'])) { if (!$setter) { throw new HTTP_Request2_LogicException( 'Cookie misses domain and/or path component, cookie setter URL needed', HTTP_Request2_Exception::MISSING_VALUE ); } if (empty($cookie['domain'])) { if ($host = $setter->getHost()) { $cookie['domain'] = $host; } else { throw new HTTP_Request2_LogicException( 'Setter URL does not contain host part, can\'t set cookie domain', HTTP_Request2_Exception::MISSING_VALUE ); } } if (empty($cookie['path'])) { $path = $setter->getPath(); $cookie['path'] = empty($path)? '/': substr($path, 0, strrpos($path, '/') + 1); } } if ($setter && !$this->domainMatch($setter->getHost(), $cookie['domain'])) { throw new HTTP_Request2_MessageException( "Domain " . $setter->getHost() . " cannot set cookies for " . $cookie['domain'] ); } return $cookie; } public function store(array $cookie, Net_URL2 $setter = null) { $cookie = $this->checkAndUpdateFields($cookie, $setter); if (strlen($cookie['value']) && (is_null($cookie['expires']) || $cookie['expires'] > $this->now()) ) { if (!isset($this->cookies[$cookie['domain']])) { $this->cookies[$cookie['domain']] = array(); } if (!isset($this->cookies[$cookie['domain']][$cookie['path']])) { $this->cookies[$cookie['domain']][$cookie['path']] = array(); } $this->cookies[$cookie['domain']][$cookie['path']][$cookie['name']] = $cookie; } elseif (isset($this->cookies[$cookie['domain']][$cookie['path']][$cookie['name']])) { unset($this->cookies[$cookie['domain']][$cookie['path']][$cookie['name']]); } } public function addCookiesFromResponse(HTTP_Request2_Response $response, Net_URL2 $setter) { foreach ($response->getCookies() as $cookie) { $this->store($cookie, $setter); } } public function getMatching(Net_URL2 $url, $asString = false) { $host = $url->getHost(); $path = $url->getPath(); $secure = 0 == strcasecmp($url->getScheme(), 'https'); $matched = $ret = array(); foreach (array_keys($this->cookies) as $domain) { if ($this->domainMatch($host, $domain)) { foreach (array_keys($this->cookies[$domain]) as $cPath) { if (0 === strpos($path, $cPath)) { foreach ($this->cookies[$domain][$cPath] as $name => $cookie) { if (!$cookie['secure'] || $secure) { $matched[$name][strlen($cookie['path'])] = $cookie; } } } } } } foreach ($matched as $cookies) { krsort($cookies); $ret = array_merge($ret, $cookies); } if (!$asString) { return $ret; } else { $str = ''; foreach ($ret as $c) { $str .= (empty($str)? '': '; ') . $c['name'] . '=' . $c['value']; } return $str; } } public function getAll() { $cookies = array(); foreach (array_keys($this->cookies) as $domain) { foreach (array_keys($this->cookies[$domain]) as $path) { foreach ($this->cookies[$domain][$path] as $name => $cookie) { $cookies[] = $cookie; } } } return $cookies; } public function serializeSessionCookies($serialize) { $this->serializeSession = (bool)$serialize; } public function usePublicSuffixList($useList) { $this->useList = (bool)$useList; } public function serialize() { $cookies = $this->getAll(); if (!$this->serializeSession) { for ($i = count($cookies) - 1; $i >= 0; $i--) { if (empty($cookies[$i]['expires'])) { unset($cookies[$i]); } } } return serialize(array( 'cookies' => $cookies, 'serializeSession' => $this->serializeSession, 'useList' => $this->useList )); } public function unserialize($serialized) { $data = unserialize($serialized); $now = $this->now(); $this->serializeSessionCookies($data['serializeSession']); $this->usePublicSuffixList($data['useList']); foreach ($data['cookies'] as $cookie) { if (!empty($cookie['expires']) && $cookie['expires'] <= $now) { continue; } if (!isset($this->cookies[$cookie['domain']])) { $this->cookies[$cookie['domain']] = array(); } if (!isset($this->cookies[$cookie['domain']][$cookie['path']])) { $this->cookies[$cookie['domain']][$cookie['path']] = array(); } $this->cookies[$cookie['domain']][$cookie['path']][$cookie['name']] = $cookie; } } public function domainMatch($requestHost, $cookieDomain) { if ($requestHost == $cookieDomain) { return true; } if (preg_match('/^(?:\d{1,3}\.){3}\d{1,3}$/', $requestHost)) { return false; } if ('.' != $cookieDomain[0]) { $cookieDomain = '.' . $cookieDomain; } if (!$this->useList && substr_count($cookieDomain, '.') < 2 || $this->useList && !self::getRegisteredDomain($cookieDomain) ) { return false; } return substr('.' . $requestHost, -strlen($cookieDomain)) == $cookieDomain; } public static function getRegisteredDomain($domain) { $domainParts = explode('.', ltrim($domain, '.')); if (empty(self::$psl)) { $path = '@data_dir@' . DIRECTORY_SEPARATOR . 'HTTP_Request2'; if (0 === strpos($path, '@' . 'data_dir@')) { $path = realpath(dirname(__FILE__) . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'data'); } self::$psl = include_once $path . DIRECTORY_SEPARATOR . 'public-suffix-list.php'; } if (!($result = self::checkDomainsList($domainParts, self::$psl))) { return false; } if (!strpos($result, '.')) { if (2 > ($count = count($domainParts))) { return false; } return $domainParts[$count - 2] . '.' . $domainParts[$count - 1]; } return $result; } protected static function checkDomainsList(array $domainParts, $listNode) { $sub = array_pop($domainParts); $result = null; if (!is_array($listNode) || is_null($sub) || array_key_exists('!' . $sub, $listNode) ) { return $sub; } elseif (array_key_exists($sub, $listNode)) { $result = self::checkDomainsList($domainParts, $listNode[$sub]); } elseif (array_key_exists('*', $listNode)) { $result = self::checkDomainsList($domainParts, $listNode['*']); } else { return $sub; } return (strlen($result) > 0) ? ($result . '.' . $sub) : null; } } class HTTP_Request2_MultipartBody { private $_boundary; private $_params = array(); private $_uploads = array(); private $_headerParam = "--%s\r\nContent-Disposition: form-data; name=\"%s\"\r\n\r\n"; private $_headerUpload = "--%s\r\nContent-Disposition: form-data; name=\"%s\"; filename=\"%s\"\r\nContent-Type: %s\r\n\r\n"; private $_pos = array(0, 0); public function __construct(array $params, array $uploads, $useBrackets = true) { $this->_params = self::_flattenArray('', $params, $useBrackets); foreach ($uploads as $fieldName => $f) { if (!is_array($f['fp'])) { $this->_uploads[] = $f + array('name' => $fieldName); } else { for ($i = 0; $i < count($f['fp']); $i++) { $upload = array( 'name' => ($useBrackets? $fieldName . '[' . $i . ']': $fieldName) ); foreach (array('fp', 'filename', 'size', 'type') as $key) { $upload[$key] = $f[$key][$i]; } $this->_uploads[] = $upload; } } } } public function getLength() { $boundaryLength = strlen($this->getBoundary()); $headerParamLength = strlen($this->_headerParam) - 4 + $boundaryLength; $headerUploadLength = strlen($this->_headerUpload) - 8 + $boundaryLength; $length = $boundaryLength + 6; foreach ($this->_params as $p) { $length += $headerParamLength + strlen($p[0]) + strlen($p[1]) + 2; } foreach ($this->_uploads as $u) { $length += $headerUploadLength + strlen($u['name']) + strlen($u['type']) + strlen($u['filename']) + $u['size'] + 2; } return $length; } public function getBoundary() { if (empty($this->_boundary)) { $this->_boundary = '--' . md5('PEAR-HTTP_Request2-' . microtime()); } return $this->_boundary; } public function read($length) { $ret = ''; $boundary = $this->getBoundary(); $paramCount = count($this->_params); $uploadCount = count($this->_uploads); while ($length > 0 && $this->_pos[0] <= $paramCount + $uploadCount) { $oldLength = $length; if ($this->_pos[0] < $paramCount) { $param = sprintf($this->_headerParam, $boundary, $this->_params[$this->_pos[0]][0]) . $this->_params[$this->_pos[0]][1] . "\r\n"; $ret .= substr($param, $this->_pos[1], $length); $length -= min(strlen($param) - $this->_pos[1], $length); } elseif ($this->_pos[0] < $paramCount + $uploadCount) { $pos = $this->_pos[0] - $paramCount; $header = sprintf($this->_headerUpload, $boundary, $this->_uploads[$pos]['name'], $this->_uploads[$pos]['filename'], $this->_uploads[$pos]['type']); if ($this->_pos[1] < strlen($header)) { $ret .= substr($header, $this->_pos[1], $length); $length -= min(strlen($header) - $this->_pos[1], $length); } $filePos = max(0, $this->_pos[1] - strlen($header)); if ($length > 0 && $filePos < $this->_uploads[$pos]['size']) { $ret .= fread($this->_uploads[$pos]['fp'], $length); $length -= min($length, $this->_uploads[$pos]['size'] - $filePos); } if ($length > 0) { $start = $this->_pos[1] + ($oldLength - $length) - strlen($header) - $this->_uploads[$pos]['size']; $ret .= substr("\r\n", $start, $length); $length -= min(2 - $start, $length); } } else { $closing = '--' . $boundary . "--\r\n"; $ret .= substr($closing, $this->_pos[1], $length); $length -= min(strlen($closing) - $this->_pos[1], $length); } if ($length > 0) { $this->_pos = array($this->_pos[0] + 1, 0); } else { $this->_pos[1] += $oldLength; } } return $ret; } public function rewind() { $this->_pos = array(0, 0); foreach ($this->_uploads as $u) { rewind($u['fp']); } } public function __toString() { $this->rewind(); return $this->read($this->getLength()); } private static function _flattenArray($name, $values, $useBrackets) { if (!is_array($values)) { return array(array($name, $values)); } else { $ret = array(); foreach ($values as $k => $v) { if (empty($name)) { $newName = $k; } elseif ($useBrackets) { $newName = $name . '[' . $k . ']'; } else { $newName = $name; } $ret = array_merge($ret, self::_flattenArray($newName, $v, $useBrackets)); } return $ret; } } } 