<?php
/* ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL); */

require __DIR__ . '/vendor/autoload.php';

$tab = date('F Y'); // Sheet name

add_action( 'gform_after_submission', 'post_to_third_party', 10, 2 );
function post_to_third_party( $entry, $form ) {
	$client = new \Google_Client();
	$client->setApplicationName('Google Sheets with Primo');
	$client->setScopes([\Google_Service_Sheets::SPREADSHEETS]);
	$client->setAccessType('offline');
	$client->setAuthConfig(__DIR__ . '/credentials.json');

	$service = new Google_Service_Sheets($client);
	$spreadsheetId = '1qfwFXR6SEE7LaYWnTMKcT2mvDM_B74sk-AbmoX1rHT0';

	$sheets = $service->spreadsheets->get($spreadsheetId)->getSheets();
	$tabs = array();
	foreach ($sheets as $key => $sheet) {
		$tabs[] = $sheet->getProperties()->title;
	}

	if(!in_array(date('F Y'), $tabs)) {
		$body = new Google_Service_Sheets_BatchUpdateSpreadsheetRequest(array(
			'requests' => array(
				'addSheet' => array(
					'properties' => array(
						'title' => date('F Y')
					)
				)
			)
		));
		$service->spreadsheets->batchUpdate($spreadsheetId,$body);

		$newRow = [
			'EntryId',
			'Date',
			'Website',
			'Email',
			'Name',
			'Google Ads',
			'Campaign',
			'Device',
			'Location',
			'Price',
			'Account Manager',
			'Date Chased',
			'Documents Done',
			'PhoneNumber',
			'Notes',
			'Text Messages',
			'SyncStatus',
			'Social Media - Following',
			'Source',
			'IP Address',
			'ActiveCampaignId',
			'IsReturningCustomer',
			'LeadSystemId',
			'DraftTime',
			'RetryCount',
			'ReportPDF'
		];
		$rows = [$newRow];
		
		$valueRange = new \Google_Service_Sheets_ValueRange();
		$valueRange->setValues($rows);
		$options = ['valueInputOption' => 'RAW'];
		$range = date('F Y');

		$service->spreadsheets_values->append($spreadsheetId, $range, $valueRange, $options);
	}

	$range = date('F Y').'!A2:A'; //the column containing the movie title
	$response = $service->spreadsheets_values->get($spreadsheetId, $range);
	$value = $response->getValues();
	$new_line = (count($value) + 2);
	$entryIds = array();
	foreach ($value as $key => $item) {
		$entryIds[] = $item[0];
	}
	$entryId = rgar( $entry, 'id' );
	$valueRange = new \Google_Service_Sheets_ValueRange();
	$formId = rgar( $entry, 'form_id' );
	if($formId == 1 || $formId == 2 || $formId == 26 || $formId == 27) {
		$source_url = explode('&eid=', rgar($entry, 'source_url'));
		if($source_url[1]) {
			$entryKey = array_search($source_url[1], $entryIds);
			$entryKey = $entryKey+2;
			$date = date('Y-m-d H:i', strtotime(rgar( $entry, 'date_created' )));
			$website = $_GET['website'];
			if (substr($website, 0, 7) == 'http://' || substr($website, 0, 8) == 'https://') {
				$website = $website;
			} else {
				$website = 'http://'.$website;
			}
			$sales = 'simon';
			$name = rgar( $entry, '1' );
			$email = rgar( $entry, '2' );
			if($formId == 1) {
				$updateRow = [
					$entryId,
					$date,
					$website,
					$email,
					$name,
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'WebsiteOnly',
					'',
					'',
					'',
					'',
					'',
				];
			} else {
				$updateRow = [
					$entryId,
					$date,
					$website,
					$email,
					$name,
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					' ',
					'',
					'',
					'',
					'',
					'',
				];
			}
			$rows = [$updateRow];
			$valueRange->setValues($rows);
			$range = date('F Y').'!A'.$entryKey;
			$options = ['valueInputOption' => 'USER_ENTERED'];

			if($formId == 1 || $formId == 27) {
				$curl = curl_init();

				curl_setopt_array($curl, array(
					CURLOPT_URL => 'https://totally-visible.com/api/reports/store',
					CURLOPT_RETURNTRANSFER => true,
					CURLOPT_ENCODING => '',
					CURLOPT_MAXREDIRS => 10,
					CURLOPT_TIMEOUT => 0,
					CURLOPT_FOLLOWLOCATION => true,
					CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
					CURLOPT_CUSTOMREQUEST => 'POST',
					CURLOPT_POSTFIELDS => array('url' => $website, 'sales' => $sales, 'line_no' => $entryKey),
				));
				
				$response = json_decode(curl_exec($curl));
				
				curl_close($curl);
			}

			$service->spreadsheets_values->update($spreadsheetId, $range, $valueRange, $options);
		} else {
			$ip = rgar( $entry, 'ip' );
			$date = date('Y-m-d H:i', strtotime(rgar( $entry, 'date_created' )));
			if (substr(rgar($entry, '1'), 0, 7) == 'http://' || substr(rgar($entry, '1'), 0, 8) == 'https://') {
				$website = rgar( $entry, '1' );
			} else {
				$website = 'http://'.rgar( $entry, '1' );
			}
			$sales = 'simon';
			if(preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"])){
				$device = 'Mobile';
			} else {
				$device = 'Desktop';
			}
			$PublicIP = get_client_ip();
			$json = file_get_contents("http://ipinfo.io/$PublicIP/geo");
			$details = json_decode($json, true);
			$location = $details['city'];
			$source = rgar( $entry, 'source_url' );
			if($formId == 1) {
				$newRow = [
					$entryId,
					$date,
					$website,
					'',
					'',
					'',
					'',
					$device,
					$location,
					'',
					'',
					'',
					'',
					'',
					'WebsiteOnly',
					'',
					'',
					'',
					$source,
					$ip
				];
			} else {
				$newRow = [
					$entryId,
					$date,
					$website,
					'',
					'',
					'',
					'',
					$device,
					$location,
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					'',
					$source,
					$ip
				];
			}
			$rows = [$newRow];
			$options = ['valueInputOption' => 'RAW'];
			$range = date('F Y');
			$valueRange = new \Google_Service_Sheets_ValueRange();
			$valueRange->setValues($rows);

			if($formId == 1 || $formId == 27) {
				$curl = curl_init();

				curl_setopt_array($curl, array(
					CURLOPT_URL => 'https://totally-visible.com/api/reports/store',
					CURLOPT_RETURNTRANSFER => true,
					CURLOPT_ENCODING => '',
					CURLOPT_MAXREDIRS => 10,
					CURLOPT_TIMEOUT => 0,
					CURLOPT_FOLLOWLOCATION => true,
					CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
					CURLOPT_CUSTOMREQUEST => 'POST',
					CURLOPT_POSTFIELDS => array('url' => $website, 'sales' => $sales, 'line_no' => $new_line),
				));
				
				$response = json_decode(curl_exec($curl));
				
				curl_close($curl);
			}
			try {
				$service->spreadsheets_values->append($spreadsheetId, $range, $valueRange, $options);
			} catch (\Throwable $th) {
				file_put_contents(__DIR__ . 'sheets.log', date('c').' - CAPTURE RESPONSE: '.json_encode($th).PHP_EOL.PHP_EOL , FILE_APPEND);
				//throw $th;
			}
		}
	} else if($formId == 8) {
		$ip = rgar( $entry, 'ip' );
		$date = date('Y-m-d H:i', strtotime(rgar( $entry, 'date_created' )));
		$email = rgar($entry, '1');
		if (substr(rgar($entry, '2'), 0, 7) == 'http://' || substr(rgar($entry, '2'), 0, 8) == 'https://') {
			$website = rgar( $entry, '2' );
		} else {
			$website = 'http://'.rgar( $entry, '2' );
		}
		$sales = 'simon';
		if(preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"])){
			$device = 'Mobile';
		} else {
			$device = 'Desktop';
		}
		$PublicIP = get_client_ip();
		$json = file_get_contents("http://ipinfo.io/$PublicIP/geo");
		$details = json_decode($json, true);
		$location = $details['city'];
		$source = rgar( $entry, 'source_url' );
		$newRow = [
			$entryId,
			$date,
			$website,
			$email,
			'',
			'',
			'',
			$device,
			$location,
			'',
			'',
			'',
			'',
			'',
			'',
			'',
			'',
			'',
			$source,
			$ip
		];
		$rows = [$newRow];
		$options = ['valueInputOption' => 'USER_ENTERED'];
		$range = date('F Y');
		$valueRange = new \Google_Service_Sheets_ValueRange();
		$valueRange->setValues($rows);

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => 'https://totally-visible.com/api/reports/store',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'POST',
			CURLOPT_POSTFIELDS => array('url' => $website, 'sales' => $sales, 'line_no' => $new_line),
		));
		
		$response = json_decode(curl_exec($curl));
		
		curl_close($curl);

		$service->spreadsheets_values->append($spreadsheetId, $range, $valueRange, $options);
	} else if($formId == 24) {
		$ip = rgar( $entry, 'ip' );
		$date = date('Y-m-d H:i', strtotime(rgar( $entry, 'date_created' )));
		$email = rgar($entry, '2');
		if (substr(rgar($entry, '1'), 0, 7) == 'http://' || substr(rgar($entry, '1'), 0, 8) == 'https://') {
			$website = rgar( $entry, '1' );
		} else {
			$website = 'http://'.rgar( $entry, '1' );
		}
		$sales = 'simon';
		if(preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"])){
			$device = 'Mobile';
		} else {
			$device = 'Desktop';
		}
		$PublicIP = get_client_ip();
		$json = file_get_contents("http://ipinfo.io/$PublicIP/geo");
		$details = json_decode($json, true);
		$location = $details['city'];
		$source = rgar( $entry, 'source_url' );
		$newRow = [
			$entryId,
			$date,
			$website,
			$email,
			'',
			'',
			'',
			$device,
			$location,
			'',
			'',
			'',
			'',
			'',
			'',
			'',
			'',
			'',
			$source,
			$ip
		];
		$rows = [$newRow];
		$options = ['valueInputOption' => 'USER_ENTERED'];
		$range = date('F Y');
		$valueRange = new \Google_Service_Sheets_ValueRange();
		$valueRange->setValues($rows);

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => 'https://totally-visible.com/api/reports/store',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'POST',
			CURLOPT_POSTFIELDS => array('url' => $website, 'sales' => $sales, 'line_no' => $new_line),
		));
		
		$response = json_decode(curl_exec($curl));
		
		curl_close($curl);

		$service->spreadsheets_values->append($spreadsheetId, $range, $valueRange, $options);
	}

	GFCommon::log_debug( 'gform_after_submission: body => ' . print_r( $rows, true ) );
}

function get_client_ip() {
	$ipaddress = '';
	if (isset($_SERVER['HTTP_CLIENT_IP'])) {
		$ipaddress = $_SERVER['HTTP_CLIENT_IP'];
	} else if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
		$ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
	} else if (isset($_SERVER['HTTP_X_FORWARDED'])) {
		$ipaddress = $_SERVER['HTTP_X_FORWARDED'];
	} else if (isset($_SERVER['HTTP_FORWARDED_FOR'])) {
		$ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
	} else if (isset($_SERVER['HTTP_FORWARDED'])) {
		$ipaddress = $_SERVER['HTTP_FORWARDED'];
	} else if (isset($_SERVER['REMOTE_ADDR'])) {
		$ipaddress = $_SERVER['REMOTE_ADDR'];
	} else {
		$ipaddress = 'UNKNOWN';
	}

	return $ipaddress;
}